/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.monitoring;

import android.app.ActivityManager;
import android.app.IntentService;
import android.content.ComponentName;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.common.Util;
import com.tendarts.sdk.communications.Communications;
import com.tendarts.sdk.communications.ICommunicationObserver;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class IntentMonitorService
extends IntentService {
    private static String a = "intent monitor";

    public IntentMonitorService() {
        super("default");
    }

    public IntentMonitorService(String name) {
        super(name);
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        String string2 = "";
        if (intent != null) {
            string2 = intent.getDataString();
        }
        Log.d((String)a, (String)("onHandleIntent: " + string2));
        String string3 = this.getApplicationContext().getApplicationInfo().packageName;
        long l = new Date().getTime();
        if (!this.isForeground(string3)) {
            Log.d((String)a, (String)"not on foreground sleeping ");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        boolean bl = false;
        while (this.isForeground(string3)) {
            Log.d((String)a, (String)"on foreground");
            bl = true;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (bl) {
            long l2 = new Date().getTime() - l;
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("push", (Object)String.format("https://10darts.com/api/v1/pushes/%s/", string2));
                jSONObject.put("device", (Object)Util.getFullDeviceUrl(this.getApplicationContext()));
                jSONObject.put("kind", (Object)"/api/v1/event_kinds/session/");
                jSONObject.put("value", Math.ceil((double)l2 / 1000.0));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            Log.d((String)a, (String)("json: " + jSONObject.toString()));
            Communications.postData("https://10darts.com/api/v1/events/", Util.getProvider(), 0, new ICommunicationObserver(){

                @Override
                public void onSuccess(int operationId, JSONObject data) {
                    TendartsClient.instance(IntentMonitorService.this.getApplicationContext()).logEvent("SDK", "session sent", "" + data);
                    Log.d((String)a, (String)"session sent");
                }

                @Override
                public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                    Util.checkUnauthorized(reason, IntentMonitorService.this.getApplicationContext());
                    TendartsClient.instance(IntentMonitorService.this.getApplicationContext()).logEvent("SDK", "session sent", "" + reason);
                    Log.d((String)a, (String)("can't send session" + reason));
                }
            }, jSONObject.toString());
        }
    }

    public boolean isForeground(String myPackage) {
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        List list = activityManager.getRunningTasks(1);
        ComponentName componentName = ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity;
        return componentName.getPackageName().equals(myPackage);
    }
}

