/*
 * Copyright   Loy Fu. 付厚俊
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
package com.loy.e.data.permission.domain.entity;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.loy.e.common.annotation.Author;
import com.loy.e.core.entity.BaseEntity;
import com.loy.upm.sys.domain.entity.RoleEntity;
import com.loy.upm.sys.domain.entity.UserEntity;

@Author(author = "Loy Fu", website = "http://www.17jee.com", contact = "qq群 540553957")
@Entity
@Table(name = "e_data_strategy")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public class DataStrategyEntity extends BaseEntity {

	private static final long serialVersionUID = -5581054133381389799L;
	@Column(length = 255)
	private String name;
	@Lob
	@Column(nullable = false)
	private String ql;
	private String uniqueKey;// *代表所有
	private Boolean effective = Boolean.TRUE;
	@Column(length = 255)
	private String description;

	@JsonIgnore
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(name = "e_strategy_role", joinColumns = { @JoinColumn(name = "strategy_id") }, inverseJoinColumns = {
			@JoinColumn(name = "role_id") })
	@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
	private Set<RoleEntity> roles = new HashSet<RoleEntity>();

	@JsonIgnore
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(name = "e_strategy_user", joinColumns = { @JoinColumn(name = "strategy_id") }, inverseJoinColumns = {
			@JoinColumn(name = "user_id") })
	@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
	private Set<UserEntity> users = new HashSet<UserEntity>();

	public String getUniqueKey() {
		return uniqueKey;
	}

	public void setUniqueKey(String uniqueKey) {
		this.uniqueKey = uniqueKey;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getQl() {
		return ql;
	}

	public void setQl(String ql) {
		this.ql = ql;
	}

	public Boolean getEffective() {
		return effective;
	}

	public void setEffective(Boolean effective) {
		this.effective = effective;
	}

	public Set<RoleEntity> getRoles() {
		return roles;
	}

	public void setRoles(Set<RoleEntity> roles) {
		this.roles = roles;
	}

	public Set<UserEntity> getUsers() {
		return users;
	}

	public void setUsers(Set<UserEntity> users) {
		this.users = users;
	}

}
