/*
 * Copyright   Loy Fu. 付厚俊
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
package com.loy.e.data.permission.repository;

import java.util.List;

import javax.persistence.QueryHint;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;

import com.loy.e.common.annotation.Author;
import com.loy.e.core.query.annotation.DynamicQuery;
import com.loy.e.core.repository.GenericRepository;
import com.loy.e.data.permission.domain.DataStrategyQueryParam;
import com.loy.e.data.permission.domain.entity.DataStrategyEntity;
import com.loy.upm.sys.domain.entity.RoleEntity;
@Author(author = "Loy Fu", website = "http://www.17jee.com", contact = "qq群 540553957")
public interface DataStrategyRepository extends GenericRepository<DataStrategyEntity, String> {

	@Query(value = "select distinct x from DataStrategyEntity  x "
			+ " join x.roles xr left join x.users xu,"
			+ " UserEntity u join u.roles ur  "
			+ " where ((xr.id = ur.id  and u.id = ?1) or xu.id = ?1 ) and x.uniqueKey = ?2")
	@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") })
	List<DataStrategyEntity> findByUserId(String userId, String uniqueKey);
	
	
	@Query(value = "select distinct x from DataStrategyEntity  x "
			+ " join x.roles xr left join x.users xu,"
			+ " UserEntity u join u.roles ur  "
			+ " where (xr.id = ur.id  and u.id = ?1) or ( xu.id = ?1 )  order by x.uniqueKey  asc ")
	@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") })
	List<DataStrategyEntity> findByUserId(String userId);

	@Query(value = " from DataStrategyEntity x where 1=1 "
			+ "<notEmpty name='uniqueKey'> and x.uniqueKey = :uniqueKey </notEmpty> "
			+ "<notEmpty name='name'> and x.name like '%${name}%'</notEmpty> ")
	@DynamicQuery
	Page<DataStrategyEntity> queryDataStrategyPage(DataStrategyQueryParam dataStrategy, Pageable pageable);

	@Query(value = "select x.roles from DataStrategyEntity x where x.id = ?1")
	List<RoleEntity> findRolesByStrategyId(String strategyId);
	
	@Query(value = "select x from DataStrategyEntity x join x.roles xr  where xr.id = ?1")
	@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") }) 
	List<DataStrategyEntity> findByRoleId(String roleId);
	
	@Query(value = " from DataStrategyEntity")
    @QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") }) 
	List<DataStrategyEntity> findAll();
}
