/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import com.onegravity.contactpicker.ContactElement;
import com.onegravity.contactpicker.R;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseFragment
extends Fragment
implements SearchView.OnQueryTextListener {
    private String[] mQueryStrings;
    private View mRootLayout;
    private RecyclerView mRecyclerView;
    private View mFastScroll;
    private View mSectionIndex;
    private View mEmptyView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        if (savedInstanceState != null) {
            this.mQueryStrings = (String[])savedInstanceState.getSerializable("mQueryStrings");
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mQueryStrings", (Serializable)this.mQueryStrings);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    protected final View createView(LayoutInflater inflater, int layoutId, RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter, List<? extends ContactElement> elements) {
        this.mRootLayout = inflater.inflate(layoutId, null);
        this.mRecyclerView = (RecyclerView)this.mRootLayout.findViewById(16908298);
        this.mFastScroll = this.mRootLayout.findViewById(R.id.fast_scroller);
        this.mSectionIndex = this.mRootLayout.findViewById(R.id.fast_scroller_section_title_indicator);
        this.mEmptyView = this.mRootLayout.findViewById(16908292);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRecyclerView.setAdapter(adapter);
        this.updateEmptyViewVisibility(elements);
        return this.mRootLayout;
    }

    protected void updateEmptyViewVisibility(List<? extends ContactElement> elements) {
        boolean isEmpty = elements == null || elements.isEmpty();
        this.mRecyclerView.setVisibility(isEmpty ? 8 : 0);
        if (this.mFastScroll != null) {
            this.mFastScroll.setVisibility(isEmpty ? 8 : 0);
        }
        if (this.mSectionIndex != null) {
            this.mSectionIndex.setVisibility(isEmpty ? 8 : 0);
        }
        this.mEmptyView.setVisibility(isEmpty ? 0 : 8);
    }

    public void onResume() {
        super.onResume();
        EventBus.getDefault().register((Object)this);
        if (this.mQueryStrings != null && this.mQueryStrings.length > 0) {
            this.performFiltering(this.mQueryStrings);
        }
    }

    public void onPause() {
        super.onPause();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        MenuItem item = menu.findItem(R.id.action_search);
        SearchView searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)item);
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_check_all) {
            this.checkAll();
            return true;
        }
        return false;
    }

    protected abstract void checkAll();

    public final boolean onQueryTextSubmit(String query) {
        return this.onQuery(query);
    }

    public final boolean onQueryTextChange(String query) {
        return this.onQuery(query);
    }

    private boolean onQuery(String query) {
        String queryString = query.toString().toLowerCase(Locale.getDefault());
        this.mQueryStrings = queryString.split(" ");
        this.performFiltering(this.mQueryStrings);
        return true;
    }

    protected abstract void performFiltering(String[] var1);
}

