/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.contact;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SectionIndexer;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.contact.ContactDescription;
import com.onegravity.contactpicker.contact.ContactSection;
import com.onegravity.contactpicker.contact.ContactSortOrder;
import com.onegravity.contactpicker.contact.ContactViewHolder;
import com.onegravity.contactpicker.picture.ContactPictureManager;
import com.onegravity.contactpicker.picture.ContactPictureType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactAdapter
extends RecyclerView.Adapter<ContactViewHolder>
implements SectionIndexer {
    private List<? extends Contact> mContacts;
    private final ContactSortOrder mSortOrder;
    private final ContactPictureType mContactPictureType;
    private final ContactDescription mContactDescription;
    private final int mContactDescriptionType;
    private final ContactPictureManager mContactPictureLoader;
    private LayoutInflater mInflater;
    private Map<Character, ContactSection> mSections = new HashMap<Character, ContactSection>();
    private ContactSection[] mSectionArray;

    public ContactAdapter(Context context, List<Contact> contacts, ContactSortOrder sortOrder, ContactPictureType contactPictureType, ContactDescription contactDescription, int contactDescriptionType) {
        this.mContacts = contacts;
        this.mSortOrder = sortOrder;
        this.mContactPictureType = contactPictureType;
        this.mContactDescription = contactDescription;
        this.mContactDescriptionType = contactDescriptionType;
        this.mContactPictureLoader = new ContactPictureManager(context, this.mContactPictureType == ContactPictureType.ROUND);
    }

    public void setData(List<? extends Contact> contacts) {
        this.mContacts = contacts;
        this.notifyDataSetChanged();
        this.calculateSections();
    }

    public ContactViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mInflater == null) {
            this.mInflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
        }
        View view = this.mInflater.inflate(R.layout.contact_list_item, parent, false);
        return new ContactViewHolder(view, this.mContactPictureLoader, this.mContactPictureType, this.mContactDescription, this.mContactDescriptionType);
    }

    public void onBindViewHolder(ContactViewHolder holder, int position) {
        if (this.mContacts != null) {
            holder.bind(this.mContacts.get(position));
        }
    }

    public void onViewRecycled(ContactViewHolder holder) {
        holder.onRecycled();
    }

    public int getItemCount() {
        return this.mContacts == null ? 0 : this.mContacts.size();
    }

    public long getItemId(int position) {
        return this.mContacts == null ? super.getItemId(position) : this.mContacts.get(position).getId();
    }

    private synchronized void calculateSections() {
        this.mSections.clear();
        ArrayList<ContactSection> sectionArray = new ArrayList<ContactSection>();
        if (this.mContacts != null) {
            int contactPos = 0;
            int sectionPos = 0;
            char prevLetter = '\u0000';
            for (Contact contact : this.mContacts) {
                char letter = contact.getContactLetter(this.mSortOrder);
                if (letter != prevLetter) {
                    ContactSection newSection = new ContactSection(letter, sectionPos++, contactPos);
                    this.mSections.put(Character.valueOf(letter), newSection);
                    sectionArray.add(newSection);
                    prevLetter = letter;
                }
                ++contactPos;
            }
        }
        this.mSectionArray = sectionArray.toArray(new ContactSection[sectionArray.size()]);
    }

    public synchronized Object[] getSections() {
        return this.mSectionArray;
    }

    public synchronized int getPositionForSection(int sectionPos) {
        if (this.mSections == null || this.mSections.isEmpty() || this.mContacts == null || this.mContacts.isEmpty()) {
            return 0;
        }
        int maxIndexSections = this.assertBoundaries(this.mSectionArray.length - 1, 0, this.mSectionArray.length);
        sectionPos = this.assertBoundaries(sectionPos, 0, maxIndexSections);
        int contactPos = this.mSectionArray[sectionPos].getContactPos();
        int maxIndexContacts = this.assertBoundaries(this.mContacts.size() - 1, 0, this.mContacts.size());
        return this.assertBoundaries(contactPos, 0, maxIndexContacts);
    }

    public synchronized int getSectionForPosition(int contactPosition) {
        if (this.mSections == null || this.mSections.isEmpty() || this.mContacts == null || this.mContacts.isEmpty()) {
            return 0;
        }
        int maxIndexContacts = this.assertBoundaries(this.mContacts.size() - 1, 0, this.mContacts.size());
        char contactLetter = this.mContacts.get(contactPosition = this.assertBoundaries(contactPosition, 0, maxIndexContacts)).getContactLetter(this.mSortOrder);
        ContactSection section = this.mSections.get(Character.valueOf(contactLetter));
        int sectionPos = section != null ? section.getSectionPos() : 0;
        int maxIndexSections = this.assertBoundaries(this.mSectionArray.length - 1, 0, this.mSectionArray.length);
        return this.assertBoundaries(sectionPos, 0, maxIndexSections);
    }

    private int assertBoundaries(int index, int lower, int upper) {
        return Math.max(lower, Math.min(index, upper));
    }
}

