/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.contact;

import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.onegravity.contactpicker.BaseFragment;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.contact.ContactAdapter;
import com.onegravity.contactpicker.contact.ContactDescription;
import com.onegravity.contactpicker.contact.ContactSelectionChanged;
import com.onegravity.contactpicker.contact.ContactSortOrder;
import com.onegravity.contactpicker.contact.ContactsLoaded;
import com.onegravity.contactpicker.picture.ContactPictureType;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.SectionIndicator;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.title.SectionTitleIndicator;
import xyz.danoz.recyclerviewfastscroller.vertical.VerticalRecyclerViewFastScroller;

public class ContactFragment
extends BaseFragment {
    private ContactSortOrder mSortOrder;
    private ContactPictureType mPictureType;
    private ContactDescription mDescription;
    private int mDescriptionType;
    private List<? extends Contact> mContacts = new ArrayList<Contact>();
    private List<? extends Contact> mFilteredContacts = new ArrayList<Contact>();
    private ContactAdapter mAdapter;

    public static ContactFragment newInstance(ContactSortOrder sortOrder, ContactPictureType pictureType, ContactDescription contactDescription, int descriptionType) {
        Bundle args = new Bundle();
        args.putString("sortOrder", sortOrder.name());
        args.putString("pictureType", pictureType.name());
        args.putString("contactDescription", contactDescription.name());
        args.putInt("descriptionType", descriptionType);
        ContactFragment fragment = new ContactFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mSortOrder = ContactSortOrder.lookup(args.getString("sortOrder"));
        this.mPictureType = ContactPictureType.lookup(args.getString("pictureType"));
        this.mDescription = ContactDescription.lookup(args.getString("contactDescription"));
        this.mDescriptionType = args.getInt("descriptionType");
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mAdapter = new ContactAdapter(this.getContext(), null, this.mSortOrder, this.mPictureType, this.mDescription, this.mDescriptionType);
        View rootLayout = super.createView(inflater, R.layout.contact_list, this.mAdapter, this.mContacts);
        RecyclerView recyclerView = (RecyclerView)rootLayout.findViewById(16908298);
        VerticalRecyclerViewFastScroller fastScroller = (VerticalRecyclerViewFastScroller)rootLayout.findViewById(R.id.fast_scroller);
        fastScroller.setRecyclerView(recyclerView);
        recyclerView.addOnScrollListener(fastScroller.getOnScrollListener());
        SectionTitleIndicator sectionTitleIndicator = (SectionTitleIndicator)rootLayout.findViewById(R.id.fast_scroller_section_title_indicator);
        fastScroller.setSectionIndicator((SectionIndicator)sectionTitleIndicator);
        return rootLayout;
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public void onEventMainThread(ContactsLoaded event) {
        EventBus.getDefault().removeStickyEvent((Object)event);
        this.mContacts = event.getContacts();
        this.mFilteredContacts = this.mContacts;
        this.mAdapter.setData(this.mFilteredContacts);
        this.updateEmptyViewVisibility(this.mContacts);
    }

    @Override
    protected void checkAll() {
        if (this.mFilteredContacts == null) {
            return;
        }
        boolean allChecked = true;
        for (Contact contact : this.mFilteredContacts) {
            if (contact.isChecked()) continue;
            allChecked = false;
            break;
        }
        boolean isChecked = !allChecked;
        for (Contact contact : this.mFilteredContacts) {
            if (contact.isChecked() == isChecked) continue;
            contact.setChecked(isChecked, true);
        }
        ContactSelectionChanged.post();
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    protected void performFiltering(String[] queryStrings) {
        if (this.mContacts == null) {
            return;
        }
        if (queryStrings == null || queryStrings.length == 0) {
            this.mFilteredContacts = this.mContacts;
        } else {
            ArrayList<? extends Contact> filteredElements = new ArrayList<Contact>();
            for (Contact contact : this.mContacts) {
                if (!contact.matchesQuery(queryStrings)) continue;
                filteredElements.add(contact);
            }
            this.mFilteredContacts = filteredElements;
        }
        this.mAdapter.setData(this.mFilteredContacts);
    }
}

