/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.core;

import com.onegravity.contactpicker.ContactElement;
import com.onegravity.contactpicker.Helper;
import com.onegravity.contactpicker.OnContactCheckedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

abstract class ContactElementImpl
implements ContactElement {
    private final long mId;
    private final String mDisplayName;
    private transient List<OnContactCheckedListener> mListeners = new ArrayList<OnContactCheckedListener>();
    private transient boolean mChecked = false;

    ContactElementImpl(long id2, String displayName) {
        this.mId = id2;
        this.mDisplayName = Helper.isNullOrEmpty(displayName) ? "---" : displayName;
    }

    @Override
    public long getId() {
        return this.mId;
    }

    @Override
    public String getDisplayName() {
        return this.mDisplayName != null ? this.mDisplayName : "";
    }

    @Override
    public boolean isChecked() {
        return this.mChecked;
    }

    @Override
    public void setChecked(boolean checked, boolean suppressListenerCall) {
        boolean wasChecked = this.mChecked;
        this.mChecked = checked;
        if (!this.mListeners.isEmpty() && wasChecked != checked && !suppressListenerCall) {
            for (OnContactCheckedListener listener : this.mListeners) {
                listener.onContactChecked(this, wasChecked, checked);
            }
        }
    }

    @Override
    public void addOnContactCheckedListener(OnContactCheckedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public boolean matchesQuery(String[] queryStrings) {
        String dispName = this.getDisplayName();
        if (Helper.isNullOrEmpty(dispName)) {
            return false;
        }
        dispName = dispName.toLowerCase(Locale.getDefault());
        for (String queryString : queryStrings) {
            if (dispName.contains(queryString)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mId + ": " + this.mDisplayName;
    }
}

