/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.core;

import android.database.Cursor;
import android.net.Uri;
import com.onegravity.contactpicker.Helper;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.contact.ContactSortOrder;
import com.onegravity.contactpicker.core.ContactElementImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ContactImpl
extends ContactElementImpl
implements Contact {
    private static final Pattern CONTACT_LETTER = Pattern.compile("[^a-zA-Z]*([a-zA-Z]).*");
    private static final int[] CONTACT_COLORS_MATERIAL = new int[]{-769226, -1499549, -6543440, -10011977, -12627531, -14575885, -16537100, -16728876, -16738680, -11751600, -7617718, -3285959, -16121, -26624, -43230, -8825528, -6381922, -10453621};
    private final String mLookupKey;
    private String mFirstName = "";
    private String mLastName = "";
    private Map<Integer, String> mEmail = new HashMap<Integer, String>();
    private Map<Integer, String> mPhone = new HashMap<Integer, String>();
    private Map<Integer, String> mAddress = new HashMap<Integer, String>();
    private transient Uri mPhotoUri;
    private Set<Long> mGroupIds = new HashSet<Long>();
    private char mContactLetterBadge;
    private char mContactLetterScroll;
    private Integer mContactColor;

    static ContactImpl fromCursor(Cursor cursor) {
        String[] stringArray;
        long id2 = cursor.getLong(cursor.getColumnIndex("_id"));
        String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
        String displayName = cursor.getString(cursor.getColumnIndex("display_name"));
        if (displayName != null) {
            stringArray = displayName.split("\\s+");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "---";
            stringArray = stringArray2;
            stringArray2[1] = "---";
        }
        String[] names = stringArray;
        String firstName = names.length >= 1 ? names[0] : displayName;
        String lastName = names.length >= 2 ? names[1] : "";
        String photoUri = cursor.getString(cursor.getColumnIndex("photo_thumb_uri"));
        Uri uri = photoUri != null ? Uri.parse((String)photoUri) : null;
        return new ContactImpl(id2, lookupKey, displayName, firstName, lastName, uri);
    }

    private ContactImpl(long id2, String lookupKey, String displayName, String firstName, String lastName, Uri photoUri) {
        super(id2, displayName);
        this.mLookupKey = lookupKey;
        this.mFirstName = Helper.isNullOrEmpty(firstName) ? "---" : firstName;
        this.mLastName = Helper.isNullOrEmpty(lastName) ? "---" : lastName;
        this.mPhotoUri = photoUri;
    }

    @Override
    public String getFirstName() {
        return this.mFirstName;
    }

    @Override
    public String getLastName() {
        return this.mLastName;
    }

    @Override
    public String getEmail(int type) {
        String email = this.mEmail.get(type);
        if (email == null && !this.mEmail.isEmpty()) {
            email = this.mEmail.values().iterator().next();
        }
        return email;
    }

    @Override
    public String getPhone(int type) {
        String phone = this.mPhone.get(type);
        if (phone == null && !this.mPhone.isEmpty()) {
            phone = this.mPhone.values().iterator().next();
        }
        return phone;
    }

    @Override
    public String getAddress(int type) {
        String address = this.mAddress.get(type);
        if (address == null && !this.mAddress.isEmpty()) {
            address = this.mAddress.values().iterator().next();
        }
        return address;
    }

    @Override
    public char getContactLetter() {
        if (this.mContactLetterBadge == '\u0000') {
            Matcher m = CONTACT_LETTER.matcher(this.getDisplayName());
            String letter = m.matches() ? m.group(1).toUpperCase(Locale.US) : "?";
            this.mContactLetterBadge = (char)(Helper.isNullOrEmpty(letter) ? 63 : (int)letter.charAt(0));
        }
        return this.mContactLetterBadge;
    }

    @Override
    public char getContactLetter(ContactSortOrder sortOrder) {
        if (this.mContactLetterScroll == '\u0000') {
            String name;
            switch (sortOrder) {
                case FIRST_NAME: {
                    name = this.getFirstName();
                    break;
                }
                case LAST_NAME: {
                    name = this.getLastName();
                    break;
                }
                default: {
                    name = this.getDisplayName();
                }
            }
            this.mContactLetterScroll = (char)(Helper.isNullOrEmpty(name) ? 63 : (int)name.toUpperCase(Locale.getDefault()).charAt(0));
        }
        return this.mContactLetterScroll;
    }

    @Override
    public int getContactColor() {
        if (this.mContactColor == null) {
            String key = this.getDisplayName();
            int value = Helper.isNullOrEmpty(key) ? this.hashCode() : key.hashCode();
            this.mContactColor = CONTACT_COLORS_MATERIAL[Math.abs(value) % CONTACT_COLORS_MATERIAL.length];
        }
        return this.mContactColor;
    }

    @Override
    public String getLookupKey() {
        return this.mLookupKey;
    }

    @Override
    public Uri getPhotoUri() {
        return this.mPhotoUri;
    }

    @Override
    public Set<Long> getGroupIds() {
        return this.mGroupIds;
    }

    void setFirstName(String value) {
        this.mFirstName = value;
    }

    void setLastName(String value) {
        this.mLastName = value;
    }

    void setEmail(int type, String value) {
        this.mEmail.put(type, value);
    }

    void setPhone(int type, String value) {
        this.mPhone.put(type, value);
    }

    void setAddress(int type, String value) {
        this.mAddress.put(type, value);
    }

    void addGroupId(long value) {
        this.mGroupIds.add(value);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.mFirstName + " " + this.mLastName + ", " + this.mEmail;
    }
}

