/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.core;

import android.database.Cursor;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.core.ContactElementImpl;
import com.onegravity.contactpicker.group.Group;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class GroupImpl
extends ContactElementImpl
implements Group {
    private Map<Long, Contact> mContacts = new HashMap<Long, Contact>();

    static GroupImpl fromCursor(Cursor cursor) {
        long id2 = cursor.getLong(cursor.getColumnIndex("_id"));
        String title = cursor.getString(cursor.getColumnIndex("title"));
        return new GroupImpl(id2, title);
    }

    private GroupImpl(long id2, String displayName) {
        super(id2, displayName);
    }

    @Override
    public Collection<Contact> getContacts() {
        return this.mContacts.values();
    }

    void addContact(Contact contact) {
        long contactId = contact.getId();
        if (!this.mContacts.keySet().contains(contactId)) {
            this.mContacts.put(contact.getId(), contact);
        }
    }

    boolean hasContacts() {
        return this.mContacts.size() > 0;
    }
}

