/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.group;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.onegravity.contactpicker.BaseFragment;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.group.Group;
import com.onegravity.contactpicker.group.GroupAdapter;
import com.onegravity.contactpicker.group.GroupsLoaded;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class GroupFragment
extends BaseFragment {
    private List<? extends Group> mGroups = new ArrayList<Group>();
    private List<? extends Group> mFilteredGroups = new ArrayList<Group>();
    private GroupAdapter mAdapter;

    public static GroupFragment newInstance() {
        return new GroupFragment();
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mAdapter = new GroupAdapter(null);
        return super.createView(inflater, R.layout.group_list, this.mAdapter, this.mGroups);
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public void onEventMainThread(GroupsLoaded event) {
        EventBus.getDefault().removeStickyEvent((Object)event);
        this.mGroups = event.getGroups();
        this.mFilteredGroups = this.mGroups;
        this.mAdapter.setData(this.mFilteredGroups);
        this.updateEmptyViewVisibility(this.mGroups);
    }

    @Override
    protected void checkAll() {
        if (this.mFilteredGroups == null) {
            return;
        }
        boolean allChecked = true;
        for (Group group : this.mFilteredGroups) {
            if (group.isChecked()) continue;
            allChecked = false;
            break;
        }
        boolean isChecked = !allChecked;
        for (Group group : this.mFilteredGroups) {
            if (group.isChecked() == isChecked) continue;
            group.setChecked(isChecked, false);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    protected void performFiltering(String[] queryStrings) {
        if (this.mGroups == null) {
            return;
        }
        if (queryStrings == null || queryStrings.length == 0) {
            this.mFilteredGroups = this.mGroups;
        } else {
            ArrayList<? extends Group> filteredElements = new ArrayList<Group>();
            for (Group group : this.mGroups) {
                if (!group.matchesQuery(queryStrings)) continue;
                filteredElements.add(group);
            }
            this.mFilteredGroups = filteredElements;
        }
        this.mAdapter.setData(this.mFilteredGroups);
    }
}

