/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture;

import android.content.AsyncQueryHandler;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.util.Log;
import android.view.View;
import com.onegravity.contactpicker.Helper;
import com.onegravity.contactpicker.picture.ContactBadge;

public class ContactBadgeQueryHandler
extends AsyncQueryHandler {
    private final ContactBadge mBadge;
    private final String[] mExcludeMimes;
    private int mToken;
    private boolean mCancelled;

    public ContactBadgeQueryHandler(ContactBadge badge, String[] excludeMimes) {
        super(badge.getContext().getContentResolver());
        this.mBadge = badge;
        this.mExcludeMimes = excludeMimes;
    }

    public void startQuery(int token, Object cookie, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy) {
        this.mToken = token;
        super.startQuery(token, cookie, uri, projection, selection, selectionArgs, orderBy);
    }

    public final void cancelOperation() {
        this.mCancelled = true;
        super.cancelOperation(this.mToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
        if (this.mCancelled) {
            return;
        }
        lookupUri = null;
        createUri = null;
        trigger = false;
        extras = cookie != null ? (Bundle)cookie : new Bundle();
        try {
            switch (token) {
                case 3: {
                    trigger = true;
                    createUri = Uri.fromParts((String)"tel", (String)extras.getString("uri_content"), null);
                }
                case 1: {
                    if (cursor != null && cursor.moveToFirst()) {
                        contactId = cursor.getLong(0);
                        lookupKey = cursor.getString(1);
                        lookupUri = ContactsContract.Contacts.getLookupUri((long)contactId, (String)lookupKey);
                        ** break;
                    }
lbl18:
                    // 3 sources

                    break;
                }
                case 2: {
                    trigger = true;
                    createUri = Uri.fromParts((String)"mailto", (String)extras.getString("uri_content"), null);
                }
                case 0: {
                    if (cursor != null && cursor.moveToFirst()) {
                        contactId = cursor.getLong(0);
                        lookupKey = cursor.getString(1);
                        lookupUri = ContactsContract.Contacts.getLookupUri((long)contactId, (String)lookupKey);
                    }
                    break;
                }
                ** default:
lbl29:
                // 1 sources

                break;
            }
        }
        catch (Exception e) {
            Log.w((String)this.getClass().getSimpleName(), (String)("Failed to get email data: " + e.getMessage()));
        }
        finally {
            Helper.closeQuietly(cursor);
        }
        if (this.mCancelled) {
            return;
        }
        this.mBadge.assignContactUri(lookupUri);
        context = this.mBadge.getContext();
        if (trigger && lookupUri != null) {
            ContactsContract.QuickContact.showQuickContact((Context)context, (View)this.mBadge, (Uri)lookupUri, (int)3, (String[])this.mExcludeMimes);
        } else if (createUri != null) {
            intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", createUri);
            if (extras != null) {
                extras.remove("uri_content");
                intent.putExtras(extras);
            }
            context.startActivity(intent);
        }
    }
}

