/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.picture.ContactBadge;
import com.onegravity.contactpicker.picture.ContactPictureLoaded;
import com.onegravity.contactpicker.picture.ContactPictureLoader;
import com.onegravity.contactpicker.picture.cache.ContactPictureCache;
import com.onegravity.contactpicker.picture.cache.ContactUriCache;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ContactPictureManager {
    private static Bitmap sDummyBitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
    private static final ExecutorService sExecutor = Executors.newFixedThreadPool(2);
    private final ContactPictureCache sPhotoCache;
    private final boolean mRoundContactPictures;

    public ContactPictureManager(Context context, boolean roundContactPictures) {
        this.sPhotoCache = ContactPictureCache.getInstance(context);
        this.mRoundContactPictures = roundContactPictures;
        EventBus.getDefault().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadContactPicture(Contact contact, ContactBadge badge) {
        Bitmap bitmap;
        String key = contact.getLookupKey();
        Uri photoUri = contact.getPhotoUri();
        if (photoUri == null && (photoUri = ContactUriCache.getUriFromCache(key)) == Uri.EMPTY) {
            photoUri = Uri.parse((String)("picture://1gravity.com/" + Uri.encode((String)key)));
        }
        if ((bitmap = this.sPhotoCache.get(photoUri, sDummyBitmap)) != null && bitmap != sDummyBitmap) {
            badge.setBitmap(bitmap);
        } else if (photoUri == Uri.EMPTY || bitmap == sDummyBitmap) {
            badge.setCharacter(Character.valueOf(contact.getContactLetter()), contact.getContactColor());
        } else {
            ContactBadge contactBadge = badge;
            synchronized (contactBadge) {
                boolean hasLoaderAssociated = this.hasLoaderAssociated(key, badge);
                if (!hasLoaderAssociated) {
                    badge.setCharacter(Character.valueOf(contact.getContactLetter()), contact.getContactColor());
                    ContactPictureLoader loader = new ContactPictureLoader(key, badge, contact.getPhotoUri(), this.mRoundContactPictures);
                    badge.setKey(key);
                    try {
                        sExecutor.execute(loader);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean hasLoaderAssociated(String loaderKey, ContactBadge badge) {
        String badgeKey = badge.getKey();
        if (badgeKey == null || loaderKey == null) {
            return false;
        }
        return badgeKey.equals(loaderKey);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventMainThread(ContactPictureLoaded event) {
        ContactBadge badge = event.getBadge();
        String badgeKey = badge.getKey();
        String loaderKey = event.getKey();
        if (badgeKey != null && loaderKey != null && badgeKey.equals(loaderKey)) {
            badge.setBitmap(event.getBitmap());
        }
    }
}

