/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture.cache;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.onegravity.contactpicker.picture.cache.InMemoryCache;

public class ContactPictureCache
extends InMemoryCache<Uri, Bitmap> {
    private static ContactPictureCache sInstance;
    private static int sMemClass;

    public static synchronized ContactPictureCache getInstance(Context context) {
        if (sInstance == null) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            sMemClass = activityManager.getMemoryClass();
            sInstance = new ContactPictureCache();
        }
        return sInstance;
    }

    private ContactPictureCache() {
        super(300000, 50);
    }

    @Override
    protected InMemoryCache.HardLruCache createHardLruCache(int cacheCapacity) {
        int cacheSize = 0x100000 * sMemClass / 16;
        return new PhotoHardLruCache(cacheSize);
    }

    private class PhotoHardLruCache
    extends InMemoryCache.HardLruCache {
        public PhotoHardLruCache(int initialCapacity) {
            super(ContactPictureCache.this, initialCapacity);
        }

        protected int sizeOf(Uri key, Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }
}

