/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture.cache;

import android.os.Handler;
import android.os.Looper;
import android.util.LruCache;
import com.onegravity.contactpicker.picture.cache.Cache;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

abstract class InMemoryCache<K, V>
implements Cache<K, V> {
    private final int mDelayBeforePurge;
    private Handler mPurgeHandler;
    private Runnable mPurger;
    private final HardLruCache mHardCacheMap;
    private ConcurrentHashMap<K, SoftReference<V>> mSoftCache;
    private Set<K> mMissCache;

    protected InMemoryCache(int delayBeforePurge, int cacheCapacity) {
        this.mDelayBeforePurge = delayBeforePurge;
        try {
            this.mPurgeHandler = new Handler();
        }
        catch (RuntimeException e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    InMemoryCache.this.mPurgeHandler = new Handler();
                    Looper.loop();
                }
            }).start();
        }
        this.mPurger = new Purger();
        this.mMissCache = new HashSet<K>();
        this.mSoftCache = new ConcurrentHashMap();
        this.mHardCacheMap = this.createHardLruCache(cacheCapacity);
    }

    protected HardLruCache createHardLruCache(int cacheCapacity) {
        return new HardLruCache(cacheCapacity);
    }

    @Override
    public synchronized void evictAll() {
        this.stopPurgeTimer();
        this.clearCaches();
    }

    @Override
    public synchronized void put(K key, V value) {
        if (key != null) {
            this.mHardCacheMap.put(key, value);
            this.mMissCache.remove(key);
        }
    }

    @Override
    public synchronized V get(K key) {
        this.resetPurgeTimer();
        if (key != null) {
            Object value = this.mHardCacheMap.get(key);
            if (value != null) {
                return (V)value;
            }
            SoftReference<V> objectRef = this.mSoftCache.get(key);
            if (objectRef != null) {
                value = objectRef.get();
                if (value != null) {
                    return (V)value;
                }
                this.mSoftCache.remove(key);
            }
        }
        this.mMissCache.add(key);
        return null;
    }

    public synchronized V get(K key, V missedValue) {
        if (key != null) {
            boolean hadMiss = this.mMissCache.contains(key);
            V result = this.get(key);
            if (result != null) {
                return result;
            }
            if (hadMiss) {
                return missedValue;
            }
        }
        return null;
    }

    private void clearCaches() {
        this.mMissCache.clear();
        this.mSoftCache.clear();
        this.mHardCacheMap.evictAll();
    }

    private void stopPurgeTimer() {
        if (this.mPurgeHandler != null) {
            this.mPurgeHandler.removeCallbacks(this.mPurger);
        }
    }

    private void resetPurgeTimer() {
        if (this.mPurgeHandler != null) {
            this.mPurgeHandler.removeCallbacks(this.mPurger);
            this.mPurgeHandler.postDelayed(this.mPurger, (long)this.mDelayBeforePurge);
        }
    }

    private class Purger
    implements Runnable {
        private Purger() {
        }

        @Override
        public void run() {
            InMemoryCache.this.clearCaches();
        }
    }

    protected class HardLruCache
    extends LruCache<K, V> {
        public HardLruCache(int initialCapacity) {
            super(initialCapacity);
        }

        protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
            InMemoryCache.this.mSoftCache.put(key, new SoftReference(newValue));
        }
    }
}

