/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.contact;

import android.net.Uri;
import android.provider.ContactsContract;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.onegravity.contactpicker.Helper;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.contact.ContactDescription;
import com.onegravity.contactpicker.picture.ContactBadge;
import com.onegravity.contactpicker.picture.ContactPictureManager;
import com.onegravity.contactpicker.picture.ContactPictureType;

public class ContactViewHolder
extends RecyclerView.ViewHolder {
    private View mRoot;
    private TextView mName;
    private TextView mDescription;
    private ContactBadge mBadge;
    private CheckBox mSelect;
    private final ContactPictureType mContactPictureType;
    private final ContactDescription mContactDescription;
    private final int mContactDescriptionType;
    private final ContactPictureManager mContactPictureLoader;

    ContactViewHolder(View root, ContactPictureManager contactPictureLoader, ContactPictureType contactPictureType, ContactDescription contactDescription, int contactDescriptionType) {
        super(root);
        this.mRoot = root;
        this.mName = (TextView)root.findViewById(R.id.name);
        this.mDescription = (TextView)root.findViewById(R.id.description);
        this.mBadge = (ContactBadge)root.findViewById(R.id.contact_badge);
        this.mSelect = (CheckBox)root.findViewById(R.id.select);
        this.mContactPictureType = contactPictureType;
        this.mContactDescription = contactDescription;
        this.mContactDescriptionType = contactDescriptionType;
        this.mContactPictureLoader = contactPictureLoader;
        this.mBadge.setBadgeType(this.mContactPictureType);
    }

    void bind(final Contact contact) {
        this.mRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ContactViewHolder.this.mSelect.toggle();
            }
        });
        this.mName.setText((CharSequence)contact.getDisplayName());
        String description = "";
        switch (this.mContactDescription) {
            case EMAIL: {
                description = contact.getEmail(this.mContactDescriptionType);
                break;
            }
            case PHONE: {
                description = contact.getPhone(this.mContactDescriptionType);
                break;
            }
            case ADDRESS: {
                description = contact.getAddress(this.mContactDescriptionType);
            }
        }
        this.mDescription.setText((CharSequence)description);
        this.mDescription.setVisibility(Helper.isNullOrEmpty(description) ? 8 : 0);
        if (this.mContactPictureType == ContactPictureType.NONE) {
            this.mBadge.setVisibility(8);
        } else {
            this.mContactPictureLoader.loadContactPicture(contact, this.mBadge);
            this.mBadge.setVisibility(0);
            String lookupKey = contact.getLookupKey();
            if (lookupKey != null) {
                Uri contactUri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_LOOKUP_URI, (String)lookupKey);
                this.mBadge.assignContactUri(contactUri);
            }
        }
        this.mSelect.setOnCheckedChangeListener(null);
        this.mSelect.setChecked(contact.isChecked());
        this.mSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                contact.setChecked(isChecked, false);
            }
        });
    }

    void onRecycled() {
        this.mBadge.onDestroy();
    }
}

