/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.core;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.provider.ContactsContract;
import android.support.design.widget.TabLayout;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.onegravity.contactpicker.OnContactCheckedListener;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.contact.ContactDescription;
import com.onegravity.contactpicker.contact.ContactSelectionChanged;
import com.onegravity.contactpicker.contact.ContactSortOrder;
import com.onegravity.contactpicker.contact.ContactsLoaded;
import com.onegravity.contactpicker.core.ContactImpl;
import com.onegravity.contactpicker.core.GroupImpl;
import com.onegravity.contactpicker.core.PagerAdapter;
import com.onegravity.contactpicker.group.Group;
import com.onegravity.contactpicker.group.GroupsLoaded;
import com.onegravity.contactpicker.picture.ContactPictureType;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ContactPickerActivity
extends AppCompatActivity
implements LoaderManager.LoaderCallbacks<Cursor> {
    public static final String EXTRA_THEME = "EXTRA_THEME";
    public static final String EXTRA_CONTACT_BADGE_TYPE = "EXTRA_CONTACT_BADGE_TYPE";
    public static final String EXTRA_CONTACT_DESCRIPTION = "EXTRA_CONTACT_DESCRIPTION";
    public static final String EXTRA_SELECT_CONTACTS_LIMIT = "EXTRA_SELECT_CONTACTS_LIMIT";
    public static final String EXTRA_LIMIT_REACHED_MESSAGE = "EXTRA_LIMIT_REACHED_MESSAGE";
    public static final String EXTRA_SHOW_CHECK_ALL = "EXTRA_SHOW_CHECK_ALL";
    public static final String EXTRA_ONLY_CONTACTS_WITH_PHONE = "EXTRA_ONLY_CONTACTS_WITH_PHONE";
    public static final String EXTRA_CONTACT_DESCRIPTION_TYPE = "EXTRA_CONTACT_DESCRIPTION_TYPE";
    public static final String EXTRA_CONTACT_SORT_ORDER = "EXTRA_CONTACT_SORT_ORDER";
    public static final String EXTRA_PRESELECTED_CONTACTS = "EXTRA_PRESELECTED_CONTACTS";
    public static final String EXTRA_PRESELECTED_GROUPS = "EXTRA_PRESELECTED_GROUPS";
    public static final String RESULT_CONTACT_DATA = "RESULT_CONTACT_DATA";
    public static final String RESULT_GROUP_DATA = "RESULT_GROUP_DATA";
    private int mThemeResId;
    private ContactPictureType mBadgeType = ContactPictureType.ROUND;
    private int mDescriptionType = 1;
    private ContactDescription mDescription = ContactDescription.ADDRESS;
    private ContactSortOrder mSortOrder = ContactSortOrder.AUTOMATIC;
    private PagerAdapter mAdapter;
    private String mDefaultTitle;
    private Boolean mShowCheckAll = true;
    private static final int BATCH_SIZE = 50;
    private static final String CONTACT_IDS = "CONTACT_IDS";
    private HashSet<Long> mSelectedContactIds = new HashSet();
    private static final String GROUP_IDS = "GROUP_IDS";
    private HashSet<Long> mSelectedGroupIds = new HashSet();
    private String mLimitReachedMessage;
    private int mSelectContactsLimit = 0;
    private Boolean mOnlyWithPhoneNumbers = false;
    private static final int CONTACTS_LOADER_ID = 0;
    private static final Uri CONTACTS_URI = ContactsContract.Contacts.CONTENT_URI;
    private static final String[] CONTACTS_PROJECTION = new String[]{"_id", "lookup", "display_name", "photo_thumb_uri"};
    private static final String CONTACTS_SORT = "display_name COLLATE LOCALIZED ASC";
    private static final int CONTACT_DETAILS_LOADER_ID = 1;
    private static final Uri CONTACT_DETAILS_URI = ContactsContract.Data.CONTENT_URI;
    private static final String[] CONTACT_DETAILS_PROJECTION = new String[]{"lookup", "display_name", "mimetype", "data1", "data2", "data1", "data2", "data1", "data2", "data2", "data3", "data1"};
    private static final int GROUPS_LOADER_ID = 2;
    private static final Uri GROUPS_URI = ContactsContract.Groups.CONTENT_URI;
    private static final String[] GROUPS_PROJECTION = new String[]{"_id", "title"};
    private static final String GROUPS_SELECTION = "deleted = 0";
    private static final String GROUPS_SORT = "title COLLATE LOCALIZED ASC";
    private List<ContactImpl> mContacts = new ArrayList<ContactImpl>();
    private Map<String, ContactImpl> mContactsByLookupKey = new HashMap<String, ContactImpl>();
    private int mNrOfSelectedContacts = 0;
    private Comparator<ContactImpl> mContactComparator = new Comparator<ContactImpl>(){

        @Override
        public int compare(ContactImpl lhs, ContactImpl rhs) {
            switch (ContactPickerActivity.this.mSortOrder) {
                case FIRST_NAME: {
                    return lhs.getFirstName().compareToIgnoreCase(rhs.getFirstName());
                }
                case LAST_NAME: {
                    return lhs.getLastName().compareToIgnoreCase(rhs.getLastName());
                }
            }
            return lhs.getDisplayName().compareToIgnoreCase(rhs.getDisplayName());
        }
    };
    private List<GroupImpl> mGroups = new ArrayList<GroupImpl>();
    private Map<Long, GroupImpl> mGroupsById = new HashMap<Long, GroupImpl>();
    private List<GroupImpl> mVisibleGroups = new ArrayList<GroupImpl>();
    private OnContactCheckedListener<Contact> mContactListener = new OnContactCheckedListener<Contact>(){

        @Override
        public void onContactChecked(Contact contact, boolean wasChecked, boolean isChecked) {
            if (!wasChecked && isChecked && ContactPickerActivity.this.mSelectContactsLimit > 0 && ContactPickerActivity.this.mNrOfSelectedContacts + 1 > ContactPickerActivity.this.mSelectContactsLimit) {
                contact.setChecked(false, true);
                ContactsLoaded.post(ContactPickerActivity.this.mContacts);
                Toast.makeText((Context)ContactPickerActivity.this, (CharSequence)ContactPickerActivity.this.mLimitReachedMessage, (int)1).show();
            } else if (wasChecked != isChecked) {
                ContactPickerActivity.this.mNrOfSelectedContacts = ContactPickerActivity.this.mNrOfSelectedContacts + (isChecked ? 1 : -1);
                ContactPickerActivity.this.mNrOfSelectedContacts = Math.min(ContactPickerActivity.this.mContacts.size(), Math.max(0, ContactPickerActivity.this.mNrOfSelectedContacts));
                ContactPickerActivity.this.updateTitle();
                if (!isChecked) {
                    ContactPickerActivity.this.processGroupSelection();
                }
            }
        }
    };
    private OnContactCheckedListener<Group> mGroupListener = new OnContactCheckedListener<Group>(){

        @Override
        public void onContactChecked(Group group, boolean wasChecked, boolean isChecked) {
            if (!wasChecked && isChecked && ContactPickerActivity.this.mSelectContactsLimit > 0 && ContactPickerActivity.this.mNrOfSelectedContacts + group.getContacts().size() > ContactPickerActivity.this.mSelectContactsLimit) {
                group.setChecked(false, true);
                GroupsLoaded.post(ContactPickerActivity.this.mVisibleGroups);
                Toast.makeText((Context)ContactPickerActivity.this, (CharSequence)ContactPickerActivity.this.mLimitReachedMessage, (int)1).show();
            } else {
                ContactPickerActivity.this.processContactSelection(group, isChecked);
                ContactPickerActivity.this.processGroupSelection();
            }
        }
    };
    private static boolean sThemingChecked;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            int pid = Process.myPid();
            PackageManager pckMgr = this.getPackageManager();
            int uid = pckMgr.getApplicationInfo((String)this.getComponentName().getPackageName(), (int)128).uid;
            this.enforcePermission("android.permission.READ_CONTACTS", pid, uid, "Contact permission hasn't been granted to this app, terminating.");
        }
        catch (PackageManager.NameNotFoundException | SecurityException e) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)e.getMessage());
            this.finish();
            return;
        }
        Intent intent = this.getIntent();
        if (savedInstanceState == null) {
            try {
                PackageManager pkMgr = this.getPackageManager();
                ActivityInfo activityInfo = pkMgr.getActivityInfo(this.getComponentName(), 128);
                this.mDefaultTitle = activityInfo.loadLabel(pkMgr).toString();
            }
            catch (PackageManager.NameNotFoundException ignore) {
                this.mDefaultTitle = this.getTitle().toString();
            }
            if (intent.hasExtra(EXTRA_PRESELECTED_CONTACTS)) {
                Collection preselectedContacts = (Collection)((Object)intent.getSerializableExtra(EXTRA_PRESELECTED_CONTACTS));
                this.mSelectedContactIds.addAll(preselectedContacts);
            }
            if (intent.hasExtra(EXTRA_PRESELECTED_GROUPS)) {
                Collection preselectedGroups = (Collection)((Object)intent.getSerializableExtra(EXTRA_PRESELECTED_GROUPS));
                this.mSelectedGroupIds.addAll(preselectedGroups);
            }
            this.mThemeResId = intent.getIntExtra(EXTRA_THEME, R.style.ContactPicker_Theme_Light);
        } else {
            this.mDefaultTitle = savedInstanceState.getString("mDefaultTitle");
            this.mThemeResId = savedInstanceState.getInt("mThemeResId");
            try {
                this.mSelectedContactIds = (HashSet)savedInstanceState.getSerializable(CONTACT_IDS);
                this.mSelectedGroupIds = (HashSet)savedInstanceState.getSerializable(GROUP_IDS);
            }
            catch (ClassCastException preselectedGroups) {
                // empty catch block
            }
        }
        String enumName = intent.getStringExtra(EXTRA_CONTACT_BADGE_TYPE);
        this.mBadgeType = ContactPictureType.lookup(enumName);
        this.mSelectContactsLimit = intent.getIntExtra(EXTRA_SELECT_CONTACTS_LIMIT, 0);
        this.mShowCheckAll = this.mSelectContactsLimit > 0 ? false : intent.getBooleanExtra(EXTRA_SHOW_CHECK_ALL, true);
        this.mOnlyWithPhoneNumbers = intent.getBooleanExtra(EXTRA_ONLY_CONTACTS_WITH_PHONE, false);
        String limitMsg = intent.getStringExtra(EXTRA_LIMIT_REACHED_MESSAGE);
        this.mLimitReachedMessage = limitMsg != null ? limitMsg : this.getString(R.string.cp_limit_reached, new Object[]{this.mSelectContactsLimit});
        enumName = intent.getStringExtra(EXTRA_CONTACT_DESCRIPTION);
        this.mDescription = ContactDescription.lookup(enumName);
        this.mDescriptionType = intent.getIntExtra(EXTRA_CONTACT_DESCRIPTION_TYPE, 1);
        enumName = intent.getStringExtra(EXTRA_CONTACT_SORT_ORDER);
        this.mSortOrder = ContactSortOrder.lookup(enumName);
        this.setTheme(this.mThemeResId);
        if (!this.checkTheming()) {
            this.finish();
            return;
        }
        this.setContentView(R.layout.cp_contact_tab_layout);
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tabContent);
        tabLayout.setTabMode(1);
        tabLayout.setTabGravity(0);
        TabLayout.Tab tabContacts = tabLayout.newTab();
        tabContacts.setText(R.string.cp_contact_tab_title);
        tabLayout.addTab(tabContacts);
        TabLayout.Tab tabGroups = tabLayout.newTab();
        tabGroups.setText(R.string.cp_group_tab_title);
        tabLayout.addTab(tabGroups);
        final ViewPager viewPager = (ViewPager)this.findViewById(R.id.tabPager);
        this.mAdapter = new PagerAdapter(this.getSupportFragmentManager(), tabLayout.getTabCount(), this.mSortOrder, this.mBadgeType, this.mDescription, this.mDescriptionType);
        viewPager.setAdapter((android.support.v4.view.PagerAdapter)this.mAdapter);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(tabLayout));
        tabLayout.setOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                viewPager.setCurrentItem(tab.getPosition());
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
    }

    protected void onResume() {
        super.onResume();
        EventBus.getDefault().register((Object)this);
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        this.getSupportLoaderManager().initLoader(2, null, (LoaderManager.LoaderCallbacks)this);
    }

    protected void onPause() {
        super.onPause();
        EventBus.getDefault().unregister((Object)this);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("mDefaultTitle", this.mDefaultTitle);
        outState.putInt("mThemeResId", this.mThemeResId);
        this.mSelectedContactIds.clear();
        for (Contact contact : this.mContacts) {
            if (!contact.isChecked()) continue;
            this.mSelectedContactIds.add(contact.getId());
        }
        outState.putSerializable(CONTACT_IDS, this.mSelectedContactIds);
        this.mSelectedGroupIds.clear();
        for (Group group : this.mGroups) {
            if (!group.isChecked()) continue;
            this.mSelectedGroupIds.add(group.getId());
        }
        outState.putSerializable(GROUP_IDS, this.mSelectedGroupIds);
    }

    private void updateTitle() {
        if (this.mNrOfSelectedContacts == 0) {
            this.setTitle(this.mDefaultTitle);
        } else {
            String title = this.getString(R.string.cp_actionmode_selected, new Object[]{this.mNrOfSelectedContacts});
            this.setTitle(title);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.cp_contact_picker, menu2);
        if (!this.mShowCheckAll.booleanValue()) {
            MenuItem checkAllBtn = menu2.findItem(R.id.action_check_all);
            checkAllBtn.setVisible(this.mShowCheckAll.booleanValue());
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.setResult(0, null);
            this.finish();
            return true;
        }
        if (id2 == R.id.action_done) {
            this.onDone();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void onDone() {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        if (this.mContacts != null) {
            for (Contact contact : this.mContacts) {
                if (!contact.isChecked()) continue;
                contacts.add(contact);
            }
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        if (this.mGroups != null) {
            for (Group group : this.mGroups) {
                if (!group.isChecked()) continue;
                groups.add(group);
            }
        }
        Intent intent = new Intent();
        intent.putExtra(RESULT_CONTACT_DATA, (Serializable)contacts);
        intent.putExtra(RESULT_GROUP_DATA, (Serializable)groups);
        this.setResult(-1, intent);
        this.finish();
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        String selection = "";
        if (this.mOnlyWithPhoneNumbers.booleanValue()) {
            selection = "has_phone_number";
        }
        switch (id2) {
            case 0: {
                return new CursorLoader((Context)this, CONTACTS_URI, CONTACTS_PROJECTION, selection, null, CONTACTS_SORT);
            }
            case 1: {
                return new CursorLoader((Context)this, CONTACT_DETAILS_URI, CONTACT_DETAILS_PROJECTION, selection, null, null);
            }
            case 2: {
                return new CursorLoader((Context)this, GROUPS_URI, GROUPS_PROJECTION, GROUPS_SELECTION, null, GROUPS_SORT);
            }
        }
        return null;
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        ContactsLoaded.post(null);
        GroupsLoaded.post(null);
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        switch (loader.getId()) {
            case 0: {
                this.readContacts(cursor);
                this.getSupportLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
                break;
            }
            case 1: {
                this.readContactDetails(cursor);
                break;
            }
            case 2: {
                this.readGroups(cursor);
            }
        }
    }

    private void readContacts(Cursor cursor) {
        this.mContacts.clear();
        this.mContactsByLookupKey.clear();
        this.mNrOfSelectedContacts = 0;
        int count = 0;
        if (cursor.moveToFirst()) {
            cursor.moveToPrevious();
            while (cursor.moveToNext()) {
                ContactImpl contact = ContactImpl.fromCursor(cursor);
                this.mContacts.add(contact);
                String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
                this.mContactsByLookupKey.put(lookupKey, contact);
                boolean isChecked = this.mSelectedContactIds.contains(contact.getId());
                contact.setChecked(isChecked, true);
                this.mNrOfSelectedContacts += isChecked ? 1 : 0;
                contact.addOnContactCheckedListener(this.mContactListener);
                if (++count < 50) continue;
                this.sortAndPostCopy(this.mContacts);
                count = 0;
            }
        }
        if (count > 0) {
            this.sortAndPostCopy(this.mContacts);
        }
        this.updateTitle();
    }

    private void sortAndPostCopy(List<ContactImpl> contacts) {
        ArrayList<ContactImpl> copy = new ArrayList<ContactImpl>();
        copy.addAll(contacts);
        Collections.sort(copy, this.mContactComparator);
        ContactsLoaded.post(copy);
    }

    private void readContactDetails(Cursor cursor) {
        if (cursor != null && cursor.moveToFirst()) {
            cursor.moveToPrevious();
            while (cursor.moveToNext()) {
                String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
                ContactImpl contact = this.mContactsByLookupKey.get(lookupKey);
                if (contact == null) continue;
                this.readContactDetails(cursor, contact);
            }
        }
        this.sortAndPostCopy(this.mContacts);
        this.joinContactsAndGroups(this.mContacts);
    }

    private void readContactDetails(Cursor cursor, ContactImpl contact) {
        String mime = cursor.getString(cursor.getColumnIndex("mimetype"));
        if (mime.equals("vnd.android.cursor.item/email_v2")) {
            String email = cursor.getString(cursor.getColumnIndex("data1"));
            int type = cursor.getInt(cursor.getColumnIndex("data2"));
            if (email != null) {
                contact.setEmail(type, email);
            }
        } else if (mime.equals("vnd.android.cursor.item/phone_v2")) {
            String phone = cursor.getString(cursor.getColumnIndex("data1"));
            int type = cursor.getInt(cursor.getColumnIndex("data2"));
            if (phone != null) {
                contact.setPhone(type, phone);
            }
        } else if (mime.equals("vnd.android.cursor.item/postal-address_v2")) {
            String address = cursor.getString(cursor.getColumnIndex("data1"));
            int type = cursor.getInt(cursor.getColumnIndex("data2"));
            if (address != null) {
                contact.setAddress(type, address.replaceAll("\\n", ", "));
            }
        } else if (mime.equals("vnd.android.cursor.item/name")) {
            String firstName = cursor.getString(cursor.getColumnIndex("data2"));
            String lastName = cursor.getString(cursor.getColumnIndex("data3"));
            if (firstName != null) {
                contact.setFirstName(firstName);
            }
            if (lastName != null) {
                contact.setLastName(lastName);
            }
        } else if (mime.equals("vnd.android.cursor.item/group_membership")) {
            int groupId = cursor.getInt(cursor.getColumnIndex("data1"));
            contact.addGroupId(groupId);
        }
    }

    private void readGroups(Cursor cursor) {
        this.mGroups.clear();
        this.mGroupsById.clear();
        this.mVisibleGroups.clear();
        if (cursor.moveToFirst()) {
            cursor.moveToPrevious();
            while (cursor.moveToNext()) {
                GroupImpl group = GroupImpl.fromCursor(cursor);
                this.mGroups.add(group);
                this.mGroupsById.put(group.getId(), group);
                boolean isChecked = this.mSelectedGroupIds.contains(group.getId());
                group.setChecked(isChecked, true);
                group.addOnContactCheckedListener(this.mGroupListener);
            }
        }
        GroupsLoaded.post(this.mVisibleGroups);
        this.joinContactsAndGroups(this.mContacts);
    }

    private synchronized void joinContactsAndGroups(List<? extends Contact> contacts) {
        if (contacts == null || contacts.isEmpty()) {
            return;
        }
        if (this.mGroupsById == null || this.mGroupsById.isEmpty()) {
            return;
        }
        for (Contact contact : contacts) {
            for (Long groupId : contact.getGroupIds()) {
                GroupImpl group = this.mGroupsById.get(groupId);
                if (group == null) continue;
                if (!group.hasContacts()) {
                    this.mVisibleGroups.add(group);
                }
                group.addContact(contact);
            }
        }
        Collections.sort(this.mVisibleGroups, new Comparator<GroupImpl>(){

            @Override
            public int compare(GroupImpl lhs, GroupImpl rhs) {
                return lhs.getDisplayName().compareTo(rhs.getDisplayName());
            }
        });
        GroupsLoaded.post(this.mVisibleGroups);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventMainThread(ContactSelectionChanged event) {
        this.calcNrOfSelectedContacts();
        this.processGroupSelection();
    }

    private void processContactSelection(Group group, boolean isChecked) {
        if (group == null || this.mContacts == null) {
            return;
        }
        boolean hasChanged = false;
        for (Contact contact : group.getContacts()) {
            if (contact.isChecked() == isChecked) continue;
            contact.setChecked(isChecked, true);
            hasChanged = true;
        }
        if (hasChanged) {
            ContactsLoaded.post(this.mContacts);
            this.calcNrOfSelectedContacts();
        }
    }

    private void calcNrOfSelectedContacts() {
        if (this.mContacts == null) {
            return;
        }
        this.mNrOfSelectedContacts = 0;
        for (Contact contact : this.mContacts) {
            if (!contact.isChecked()) continue;
            ++this.mNrOfSelectedContacts;
        }
        this.updateTitle();
    }

    private void processGroupSelection() {
        if (this.mGroups == null) {
            return;
        }
        boolean hasChanged = false;
        for (Group group : this.mGroups) {
            if (!this.deselectGroup(group)) continue;
            hasChanged = true;
        }
        if (hasChanged) {
            GroupsLoaded.post(this.mVisibleGroups);
        }
    }

    private boolean deselectGroup(Group group) {
        if (group == null) {
            return false;
        }
        boolean isSelected = false;
        for (Contact groupContact : group.getContacts()) {
            if (!groupContact.isChecked()) continue;
            isSelected = true;
            break;
        }
        if (!isSelected && group.isChecked()) {
            group.setChecked(false, true);
            return true;
        }
        return false;
    }

    private boolean checkTheming() {
        int[] resIds;
        if (sThemingChecked) {
            return true;
        }
        Resources.Theme theme = this.getTheme();
        Resources res = this.getResources();
        TypedValue typedValue = new TypedValue();
        for (int resId : resIds = this.getStyleableAttributes("ContactPicker")) {
            String resName = res.getResourceEntryName(resId);
            boolean exists = theme.resolveAttribute(resId, typedValue, true);
            if (exists) continue;
            this.themeFailure(resName);
            return false;
        }
        sThemingChecked = true;
        return true;
    }

    private int[] getStyleableAttributes(String name) {
        Field[] allFields;
        for (Field field : allFields = R.styleable.class.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            try {
                return (int[])field.get(R.styleable.class);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private void themeFailure(String resName) {
        Toast.makeText((Context)this, (CharSequence)("Attribute undefined: \"" + resName + "\". " + "Did you apply the correct theme?"), (int)1).show();
        this.finish();
    }
}

