/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.group;

import android.content.res.Resources;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.contact.Contact;
import com.onegravity.contactpicker.group.Group;
import java.util.Collection;

public class GroupViewHolder
extends RecyclerView.ViewHolder {
    private View mRoot;
    private CheckBox mSelect;
    private TextView mName;
    private TextView mDescription;

    GroupViewHolder(View root) {
        super(root);
        this.mRoot = root;
        this.mSelect = (CheckBox)root.findViewById(R.id.select);
        this.mName = (TextView)root.findViewById(R.id.name);
        this.mDescription = (TextView)root.findViewById(R.id.description);
    }

    void bind(final Group group) {
        this.mRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GroupViewHolder.this.mSelect.toggle();
            }
        });
        this.mName.setText((CharSequence)group.getDisplayName());
        Collection<Contact> contacts = group.getContacts();
        Resources res = this.mRoot.getContext().getResources();
        String desc = res.getQuantityString(R.plurals.cp_group_description, contacts.size(), new Object[]{contacts.size()});
        this.mDescription.setText((CharSequence)desc);
        this.mSelect.setOnCheckedChangeListener(null);
        this.mSelect.setChecked(group.isChecked());
        this.mSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                group.setChecked(isChecked, false);
            }
        });
    }
}

