/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.PathShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.onegravity.contactpicker.Helper;
import com.onegravity.contactpicker.R;
import com.onegravity.contactpicker.picture.Constants;
import com.onegravity.contactpicker.picture.ContactPictureType;
import com.onegravity.contactpicker.picture.ContactQueryHandler;

public class ContactBadge
extends View
implements View.OnClickListener {
    public static final float STANDARD_PICTURE_SIZE = 40.0f;
    private Uri mContactUri;
    private String mContactEmail;
    private String mContactPhone;
    private ContactQueryHandler mQueryHandler;
    private Bundle mExtras = null;
    protected String[] mExcludeMimes = null;
    private final int mSizeInPx;
    private BitmapDrawable mDrawable;
    private String mChar;
    private Paint mTextPaint;
    private Rect mRect;
    private Paint mBackground;
    private ShapeDrawable mTriangle;
    private Paint mLinePaint;
    private float mOffset;
    private boolean mIsPressed;
    private ShapeDrawable mPressedOverlay;
    private boolean mRoundContactPictures = true;
    private String mKey;
    private float mDensity;
    ContactQueryHandler.ContactQueryHandlerCallback mContactQueryHandlerCallback = new ContactQueryHandler.ContactQueryHandlerCallback(){

        @Override
        public void onQueryComplete(int token, Uri uri, Bundle extras, boolean trigger, Uri createUri) {
            ContactBadge.this.assignContactUri(uri);
            if (trigger && uri != null) {
                ContactsContract.QuickContact.showQuickContact((Context)ContactBadge.this.getContext(), (View)ContactBadge.this, (Uri)uri, (int)3, (String[])ContactBadge.this.mExcludeMimes);
            } else if (createUri != null) {
                Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", createUri);
                if (extras != null) {
                    extras.remove("uri_content");
                    intent.putExtras(extras);
                }
                ContactBadge.this.getContext().startActivity(intent);
            }
        }
    };

    public ContactBadge(Context context) {
        this(context, null);
    }

    public ContactBadge(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ContactBadge(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.mQueryHandler = new ContactQueryHandler(context, this.mExcludeMimes);
        }
        this.setOnClickListener(this);
        this.mDensity = Helper.getDisplayMetrics((Context)context).density;
        this.mSizeInPx = Math.round(40.0f * this.mDensity);
        this.initBadge(context, this.mRoundContactPictures);
    }

    private void initBadge(Context context, boolean roundContactPictures) {
        if (this.mTextPaint == null) {
            this.mTextPaint = new Paint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setStyle(Paint.Style.FILL);
            this.mTextPaint.setARGB(255, 255, 255, 255);
            this.mTextPaint.setTextSize((float)this.mSizeInPx * 0.7f);
            this.mRect = new Rect();
        }
        if (roundContactPictures) {
            this.initRound(context);
        } else {
            this.initSquare(context);
        }
    }

    private void initRound(Context context) {
        if (this.mBackground == null) {
            this.mBackground = new Paint();
            this.mBackground.setStyle(Paint.Style.FILL);
            this.mBackground.setAntiAlias(true);
        }
        this.initOverlay(context, (Shape)new OvalShape());
    }

    private void initSquare(Context context) {
        if (this.mTriangle == null) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            Path chipPath = new Path();
            chipPath.moveTo(500.0f, 0.0f);
            chipPath.lineTo(500.0f, 500.0f);
            chipPath.lineTo(0.0f, 500.0f);
            chipPath.close();
            this.mTriangle = new ShapeDrawable((Shape)new PathShape(chipPath, 500.0f, 500.0f));
            this.mTriangle.setDither(true);
            int triangleColor = Color.parseColor((String)"#cc1f1f1f");
            if (theme.resolveAttribute(R.attr.cp_badgeTriangleColor, typedValue, true)) {
                triangleColor = typedValue.data;
            }
            this.mTriangle.getPaint().setColor(triangleColor);
            this.mLinePaint = new Paint();
            int lineColor = Color.parseColor((String)"#ffffffff");
            if (theme.resolveAttribute(R.attr.cp_badgeLineColor, typedValue, true)) {
                lineColor = typedValue.data;
            }
            this.mLinePaint.setColor(lineColor);
            this.mOffset = 1.5f * this.mDensity;
            this.mLinePaint.setStrokeWidth(this.mOffset);
        }
        this.initOverlay(context, (Shape)new RectShape());
    }

    private void initOverlay(Context context, Shape shape) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        this.mPressedOverlay = new ShapeDrawable(shape);
        int overlayColor = Color.parseColor((String)"#aa888888");
        if (theme.resolveAttribute(R.attr.cp_badgeOverlayColor, typedValue, true)) {
            overlayColor = typedValue.data;
        }
        Paint paint = this.mPressedOverlay.getPaint();
        paint.setColor(overlayColor);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
    }

    public synchronized void onDestroy() {
        this.mDrawable = null;
        if (this.mQueryHandler != null) {
            this.mQueryHandler.cancelOperation();
        }
        this.mQueryHandler = null;
    }

    public void setBadgeType(ContactPictureType contactPictureType) {
        this.mRoundContactPictures = contactPictureType == ContactPictureType.ROUND;
        this.initBadge(this.getContext(), this.mRoundContactPictures);
    }

    synchronized String getKey() {
        return this.mKey;
    }

    synchronized void setKey(String key) {
        this.mKey = key;
    }

    public void setCharacter(Character c, int color) {
        this.mChar = Character.toString(c.charValue());
        this.mDrawable = null;
        if (this.mRoundContactPictures) {
            this.mBackground.setColor(color);
        } else {
            this.setBackgroundColor(color);
        }
        this.invalidate();
    }

    public void setBitmap(Bitmap bitmap) {
        this.mChar = null;
        if (this.mDrawable == null || this.mDrawable.getBitmap() != bitmap) {
            this.mDrawable = new BitmapDrawable(this.getContext().getResources(), bitmap);
            this.mKey = null;
            this.invalidate();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        boolean isPressed = false;
        for (int state : this.getDrawableState()) {
            if (state != 16842919 && state != 16842908) continue;
            isPressed = true;
            break;
        }
        if (isPressed != this.mIsPressed) {
            this.mIsPressed = isPressed;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.mRoundContactPictures) {
            this.onDrawCircle(canvas, w, h);
        } else {
            this.onDrawSquare(canvas, w, h);
        }
        if (this.mIsPressed) {
            this.mPressedOverlay.setBounds(0, 0, w, h);
            this.mPressedOverlay.draw(canvas);
        }
    }

    private void onDrawCircle(Canvas canvas, int w, int h) {
        if (this.mDrawable != null) {
            this.mDrawable.setBounds(0, 0, w, h);
            this.mDrawable.draw(canvas);
        } else if (!TextUtils.isEmpty((CharSequence)this.mChar)) {
            float radius = (float)Math.min(w, h) / 2.0f;
            canvas.drawCircle(radius, radius, radius, this.mBackground);
            this.mTextPaint.getTextBounds(this.mChar, 0, 1, this.mRect);
            float width = this.mTextPaint.measureText(this.mChar);
            canvas.drawText(this.mChar, ((float)this.mSizeInPx - width) / 2.0f, (float)(this.mSizeInPx + this.mRect.height()) / 2.0f, this.mTextPaint);
        }
    }

    private void onDrawSquare(Canvas canvas, int w, int h) {
        if (this.mDrawable != null) {
            this.mDrawable.setBounds(0, 0, w, h);
            this.mDrawable.draw(canvas);
        } else if (!TextUtils.isEmpty((CharSequence)this.mChar)) {
            this.mTextPaint.getTextBounds(this.mChar, 0, 1, this.mRect);
            float width = this.mTextPaint.measureText(this.mChar);
            canvas.drawText(this.mChar, ((float)this.mSizeInPx - width) / 2.0f, (float)(this.mSizeInPx + this.mRect.height()) / 2.0f, this.mTextPaint);
        }
        if (this.isEnabled() && this.mTriangle != null) {
            int size = Math.round((float)this.mSizeInPx / 3.0f - this.mOffset / 2.0f);
            this.mTriangle.setBounds(w - size, h - size, w, h);
            this.mTriangle.draw(canvas);
            size = Math.round((float)this.mSizeInPx / 3.0f);
            canvas.drawLine((float)(w - size) - this.mOffset, (float)h + this.mOffset, (float)w + this.mOffset, (float)(h - size) - this.mOffset, this.mLinePaint);
        }
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)ContactBadge.class.getName());
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ContactBadge.class.getName());
    }

    private boolean isAssigned() {
        return this.mContactUri != null || this.mContactEmail != null || this.mContactPhone != null;
    }

    public void assignContactUri(Uri contactUri) {
        this.mContactUri = contactUri;
        this.mContactEmail = null;
        this.mContactPhone = null;
        this.onContactUriChanged();
    }

    public void assignContactFromEmail(String emailAddress, boolean lazyLookup) {
        this.assignContactFromEmail(emailAddress, lazyLookup, null);
    }

    public void assignContactFromEmail(String emailAddress, boolean lazyLookup, Bundle extras) {
        this.mContactEmail = emailAddress;
        this.mExtras = extras;
        if (!lazyLookup && this.mQueryHandler != null) {
            this.mQueryHandler.startQuery(0, null, Uri.withAppendedPath((Uri)ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, (String)Uri.encode((String)this.mContactEmail)), Constants.EMAIL_LOOKUP_PROJECTION, null, null, null, this.mContactQueryHandlerCallback);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    public void assignContactFromPhone(String phoneNumber, boolean lazyLookup) {
        this.assignContactFromPhone(phoneNumber, lazyLookup, new Bundle());
    }

    public void assignContactFromPhone(String phoneNumber, boolean lazyLookup, Bundle extras) {
        this.mContactPhone = phoneNumber;
        this.mExtras = extras;
        if (!lazyLookup && this.mQueryHandler != null) {
            this.mQueryHandler.startQuery(1, null, Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)this.mContactPhone), Constants.PHONE_LOOKUP_PROJECTION, null, null, null, this.mContactQueryHandlerCallback);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    private void onContactUriChanged() {
        this.setEnabled(this.isAssigned());
    }

    public void onClick(View v) {
        Bundle extras;
        Bundle bundle = extras = this.mExtras == null ? new Bundle() : this.mExtras;
        if (this.mContactUri != null) {
            ContactsContract.QuickContact.showQuickContact((Context)this.getContext(), (View)this, (Uri)this.mContactUri, (int)3, (String[])this.mExcludeMimes);
        } else if (this.mContactEmail != null && this.mQueryHandler != null) {
            extras.putString("uri_content", this.mContactEmail);
            this.mQueryHandler.startQuery(2, extras, Uri.withAppendedPath((Uri)ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, (String)Uri.encode((String)this.mContactEmail)), Constants.EMAIL_LOOKUP_PROJECTION, null, null, null, this.mContactQueryHandlerCallback);
        } else if (this.mContactPhone != null && this.mQueryHandler != null) {
            extras.putString("uri_content", this.mContactPhone);
            this.mQueryHandler.startQuery(3, extras, Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)this.mContactPhone), Constants.PHONE_LOOKUP_PROJECTION, null, null, null, this.mContactQueryHandlerCallback);
        } else {
            return;
        }
    }

    public void setExcludeMimes(String[] excludeMimes) {
        this.mExcludeMimes = excludeMimes;
    }
}

