/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.net.Uri;
import com.onegravity.contactpicker.Helper;
import com.onegravity.contactpicker.picture.ContactBadge;
import com.onegravity.contactpicker.picture.ContactPictureLoaded;
import com.onegravity.contactpicker.picture.cache.ContactPictureCache;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.SoftReference;

public class ContactPictureLoader
implements Runnable {
    private final String mKey;
    private final SoftReference<ContactBadge> mBadge;
    private final Uri mPhotoUri;
    private final boolean mRoundContactPictures;

    ContactPictureLoader(String key, ContactBadge badge, Uri photoUri, boolean roundContactPictures) {
        this.mKey = key;
        this.mBadge = new SoftReference<ContactBadge>(badge);
        this.mPhotoUri = photoUri;
        this.mRoundContactPictures = roundContactPictures;
    }

    @Override
    public void run() {
        ContactBadge badge = this.mBadge.get();
        if (badge == null) {
            return;
        }
        Bitmap bitmap = ContactPictureLoader.retrievePicture(badge.getContext(), this.mPhotoUri, this.mRoundContactPictures);
        if (bitmap != null) {
            ContactPictureLoaded.post(this.mKey, badge, bitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Bitmap retrievePicture(Context context, Uri photoUri, boolean roundContactPictures) {
        Bitmap bitmap;
        InputStream stream;
        block7: {
            if (context == null || photoUri == null || Helper.isNullOrEmpty(photoUri.toString())) {
                return null;
            }
            stream = null;
            bitmap = null;
            try {
                stream = context.getContentResolver().openInputStream(photoUri);
                bitmap = BitmapFactory.decodeStream((InputStream)stream);
                if (bitmap == null) break block7;
                if (bitmap.getWidth() != bitmap.getHeight()) {
                    int w = bitmap.getWidth();
                    int h = bitmap.getHeight();
                    int indent = Math.abs(w - h) / 2;
                    int x = w > h ? indent : 0;
                    int y = w < h ? indent : 0;
                    int size = Math.min(w, h);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)size, (int)size);
                }
                if (!roundContactPictures) break block7;
                bitmap = ContactPictureLoader.getRoundedBitmap(bitmap);
            }
            catch (FileNotFoundException | OutOfMemoryError throwable) {
                Helper.closeQuietly(stream);
                catch (Throwable throwable2) {
                    Helper.closeQuietly(stream);
                    throw throwable2;
                }
            }
        }
        Helper.closeQuietly(stream);
        if (bitmap != null) {
            ContactPictureCache.getInstance(context).put(photoUri, bitmap);
        }
        return bitmap;
    }

    private static Bitmap getRoundedBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)shader);
        RectF rectF = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        Canvas canvas = new Canvas(output);
        canvas.drawOval(rectF, paint);
        return output;
    }
}

