/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.contactpicker.picture;

import android.content.AsyncQueryHandler;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.util.Log;
import com.onegravity.contactpicker.Helper;

public class ContactQueryHandler
extends AsyncQueryHandler {
    private final String[] mExcludeMimes;
    private int mToken;
    private boolean mCancelled;
    private ContactQueryHandlerCallback mCallback;

    public ContactQueryHandler(Context context, String[] excludeMimes) {
        super(context.getContentResolver());
        this.mExcludeMimes = excludeMimes;
    }

    public void startQuery(int token, Object cookie, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy, ContactQueryHandlerCallback callback) {
        this.mToken = token;
        this.mCallback = callback;
        super.startQuery(token, cookie, uri, projection, selection, selectionArgs, orderBy);
    }

    public final void cancelOperation() {
        this.mCancelled = true;
        super.cancelOperation(this.mToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
        if (this.mCancelled) {
            return;
        }
        lookupUri = null;
        createUri = null;
        trigger = false;
        extras = cookie != null ? (Bundle)cookie : new Bundle();
        try {
            switch (token) {
                case 3: {
                    trigger = true;
                    createUri = Uri.fromParts((String)"tel", (String)extras.getString("uri_content"), null);
                }
                case 1: {
                    if (cursor != null && cursor.moveToFirst()) {
                        contactId = cursor.getLong(0);
                        lookupKey = cursor.getString(1);
                        lookupUri = ContactsContract.Contacts.getLookupUri((long)contactId, (String)lookupKey);
                        ** break;
                    }
lbl18:
                    // 3 sources

                    break;
                }
                case 2: {
                    trigger = true;
                    createUri = Uri.fromParts((String)"mailto", (String)extras.getString("uri_content"), null);
                }
                case 0: {
                    if (cursor != null && cursor.moveToFirst()) {
                        contactId = cursor.getLong(0);
                        lookupKey = cursor.getString(1);
                        lookupUri = ContactsContract.Contacts.getLookupUri((long)contactId, (String)lookupKey);
                    }
                    break;
                }
                ** default:
lbl29:
                // 1 sources

                break;
            }
        }
        catch (Exception e) {
            Log.w((String)this.getClass().getSimpleName(), (String)("Failed to get data: " + e.getMessage()));
        }
        finally {
            Helper.closeQuietly(cursor);
        }
        if (this.mCancelled) {
            return;
        }
        this.mCallback.onQueryComplete(token, lookupUri, extras, trigger, createUri);
    }

    public static interface ContactQueryHandlerCallback {
        public void onQueryComplete(int var1, Uri var2, Bundle var3, boolean var4, Uri var5);
    }
}

