/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.toolbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ImageButton;
import com.onegravity.rteditor.toolbar.R;

public class RTToolbarImageButton
extends ImageButton {
    private static final int[] CHECKED_STATE_SET = new int[]{R.attr.state_checked};
    private boolean mChecked;

    public RTToolbarImageButton(Context context) {
        this(context, null);
    }

    public RTToolbarImageButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.rte_ToolbarButton);
    }

    public RTToolbarImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ToolbarButton, defStyle, 0);
        this.mChecked = a.getBoolean(R.styleable.ToolbarButton_checked, false);
        a.recycle();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + CHECKED_STATE_SET.length);
        if (this.mChecked) {
            RTToolbarImageButton.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }
}

