/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.toolbar;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import com.onegravity.colorpicker.ColorPickerDialog;
import com.onegravity.colorpicker.ColorPickerListener;
import com.onegravity.colorpicker.SetColorPickerListenerEvent;
import com.onegravity.rteditor.RTToolbar;
import com.onegravity.rteditor.RTToolbarListener;
import com.onegravity.rteditor.effects.Effect;
import com.onegravity.rteditor.effects.Effects;
import com.onegravity.rteditor.fonts.FontManager;
import com.onegravity.rteditor.fonts.RTTypeface;
import com.onegravity.rteditor.toolbar.R;
import com.onegravity.rteditor.toolbar.RTToolbarImageButton;
import com.onegravity.rteditor.toolbar.spinner.BGColorSpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.ColorSpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.FontColorSpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.FontSizeSpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.FontSpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.SpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.SpinnerItemAdapter;
import com.onegravity.rteditor.toolbar.spinner.SpinnerItems;
import com.onegravity.rteditor.utils.Helper;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HorizontalRTToolbar
extends LinearLayout
implements RTToolbar,
View.OnClickListener {
    private static AtomicInteger sIdCounter = new AtomicInteger(0);
    private int mId;
    private RTToolbarListener mListener;
    private ViewGroup mToolbarContainer;
    private RTToolbarImageButton mBold;
    private RTToolbarImageButton mItalic;
    private RTToolbarImageButton mUnderline;
    private RTToolbarImageButton mStrikethrough;
    private RTToolbarImageButton mSuperscript;
    private RTToolbarImageButton mSubscript;
    private RTToolbarImageButton mAlignLeft;
    private RTToolbarImageButton mAlignCenter;
    private RTToolbarImageButton mAlignRight;
    private RTToolbarImageButton mBullet;
    private RTToolbarImageButton mNumber;
    private Spinner mFont;
    private SpinnerItemAdapter<FontSpinnerItem> mFontAdapter;
    private Spinner mFontSize;
    private SpinnerItemAdapter<FontSizeSpinnerItem> mFontSizeAdapter;
    private Spinner mFontColor;
    private SpinnerItemAdapter<? extends ColorSpinnerItem> mFontColorAdapter;
    private Spinner mBGColor;
    private SpinnerItemAdapter<? extends ColorSpinnerItem> mBGColorAdapter;
    private int mCustomColorFont = -16777216;
    private int mCustomColorBG = -16777216;
    private int mPickerId = -1;
    private ColorPickerListener mColorPickerListener;
    private DropDownNavListener<FontSpinnerItem> mFontListener = new DropDownNavListener<FontSpinnerItem>(){

        @Override
        public void onItemSelected(FontSpinnerItem spinnerItem, int position) {
            RTTypeface typeface = spinnerItem.getTypeface();
            HorizontalRTToolbar.this.mListener.onEffectSelected(Effects.TYPEFACE, (Object)typeface);
        }
    };
    private DropDownNavListener<FontSizeSpinnerItem> mFontSizeListener = new DropDownNavListener<FontSizeSpinnerItem>(){

        @Override
        public void onItemSelected(FontSizeSpinnerItem spinnerItem, int position) {
            int size = spinnerItem.getFontSize();
            HorizontalRTToolbar.this.mFontSizeAdapter.updateSpinnerTitle(spinnerItem.isEmpty() ? "" : Integer.toString(size));
            size = Helper.convertPxToSp((int)size);
            HorizontalRTToolbar.this.mListener.onEffectSelected(Effects.FONTSIZE, (Object)size);
        }
    };
    private DropDownNavListener<FontColorSpinnerItem> mFontColorListener = new DropDownNavListener<FontColorSpinnerItem>(){

        @Override
        public void onItemSelected(final FontColorSpinnerItem spinnerItem, int position) {
            if (spinnerItem.isCustom()) {
                HorizontalRTToolbar.this.mColorPickerListener = new ColorPickerListener(){

                    public void onColorChanged(int color2) {
                        HorizontalRTToolbar.this.mCustomColorFont = color2;
                        spinnerItem.setColor(color2);
                        HorizontalRTToolbar.this.mFontColorAdapter.notifyDataSetChanged();
                        if (HorizontalRTToolbar.this.mListener != null) {
                            HorizontalRTToolbar.this.mListener.onEffectSelected(Effects.FONTCOLOR, (Object)color2);
                        }
                    }

                    public void onDialogClosing() {
                        HorizontalRTToolbar.this.mPickerId = -1;
                    }
                };
                HorizontalRTToolbar.this.mPickerId = new ColorPickerDialog(HorizontalRTToolbar.this.getContext(), HorizontalRTToolbar.this.mCustomColorFont, false).show();
                SetColorPickerListenerEvent.setListener((int)HorizontalRTToolbar.this.mPickerId, (ColorPickerListener)HorizontalRTToolbar.this.mColorPickerListener);
            } else if (HorizontalRTToolbar.this.mListener != null) {
                Integer color2 = spinnerItem.isEmpty() ? null : Integer.valueOf(spinnerItem.getColor());
                HorizontalRTToolbar.this.mListener.onEffectSelected(Effects.FONTCOLOR, (Object)color2);
            }
        }
    };
    private DropDownNavListener<BGColorSpinnerItem> mBGColorListener = new DropDownNavListener<BGColorSpinnerItem>(){

        @Override
        public void onItemSelected(final BGColorSpinnerItem spinnerItem, int position) {
            if (spinnerItem.isCustom()) {
                HorizontalRTToolbar.this.mColorPickerListener = new ColorPickerListener(){

                    public void onColorChanged(int color2) {
                        HorizontalRTToolbar.this.mCustomColorBG = color2;
                        spinnerItem.setColor(color2);
                        HorizontalRTToolbar.this.mBGColorAdapter.notifyDataSetChanged();
                        if (HorizontalRTToolbar.this.mListener != null) {
                            HorizontalRTToolbar.this.mListener.onEffectSelected(Effects.BGCOLOR, (Object)color2);
                        }
                    }

                    public void onDialogClosing() {
                        HorizontalRTToolbar.this.mPickerId = -1;
                    }
                };
                HorizontalRTToolbar.this.mPickerId = new ColorPickerDialog(HorizontalRTToolbar.this.getContext(), HorizontalRTToolbar.this.mCustomColorBG, false).show();
                SetColorPickerListenerEvent.setListener((int)HorizontalRTToolbar.this.mPickerId, (ColorPickerListener)HorizontalRTToolbar.this.mColorPickerListener);
            } else if (HorizontalRTToolbar.this.mListener != null) {
                Integer color2 = spinnerItem.isEmpty() ? null : Integer.valueOf(spinnerItem.getColor());
                HorizontalRTToolbar.this.mListener.onEffectSelected(Effects.BGCOLOR, (Object)color2);
            }
        }
    };

    public HorizontalRTToolbar(Context context) {
        super(context);
        this.init();
    }

    public HorizontalRTToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public HorizontalRTToolbar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        AtomicInteger atomicInteger = sIdCounter;
        synchronized (atomicInteger) {
            this.mId = sIdCounter.getAndIncrement();
        }
        SetColorPickerListenerEvent.setListener((int)this.mPickerId, (ColorPickerListener)this.mColorPickerListener);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mBold = this.initImageButton(R.id.toolbar_bold);
        this.mItalic = this.initImageButton(R.id.toolbar_italic);
        this.mUnderline = this.initImageButton(R.id.toolbar_underline);
        this.mStrikethrough = this.initImageButton(R.id.toolbar_strikethrough);
        this.mSuperscript = this.initImageButton(R.id.toolbar_superscript);
        this.mSubscript = this.initImageButton(R.id.toolbar_subscript);
        this.mAlignLeft = this.initImageButton(R.id.toolbar_align_left);
        this.mAlignCenter = this.initImageButton(R.id.toolbar_align_center);
        this.mAlignRight = this.initImageButton(R.id.toolbar_align_right);
        this.mBullet = this.initImageButton(R.id.toolbar_bullet);
        this.mNumber = this.initImageButton(R.id.toolbar_number);
        this.initImageButton(R.id.toolbar_inc_indent);
        this.initImageButton(R.id.toolbar_dec_indent);
        this.initImageButton(R.id.toolbar_link);
        this.initImageButton(R.id.toolbar_image);
        this.initImageButton(R.id.toolbar_undo);
        this.initImageButton(R.id.toolbar_redo);
        this.initImageButton(R.id.toolbar_clear);
        PackageManager packageMgr = this.getContext().getPackageManager();
        if (packageMgr.hasSystemFeature("android.hardware.camera")) {
            this.initImageButton(R.id.toolbar_image_capture);
        } else {
            View imageCapture = this.findViewById(R.id.toolbar_image_capture);
            if (imageCapture != null) {
                imageCapture.setVisibility(8);
            }
        }
        this.mFont = (Spinner)this.findViewById(R.id.toolbar_font);
        this.mFontAdapter = this.createDropDownNav(this.mFont, R.layout.rte_toolbar_font_spinner, R.layout.rte_toolbar_spinner_item, this.getFontItems(), this.mFontListener);
        this.mFontSize = (Spinner)this.findViewById(R.id.toolbar_fontsize);
        this.mFontSizeAdapter = this.createDropDownNav(this.mFontSize, R.layout.rte_toolbar_fontsize_spinner, R.layout.rte_toolbar_spinner_item, this.getTextSizeItems(), this.mFontSizeListener);
        this.mFontColor = (Spinner)this.findViewById(R.id.toolbar_fontcolor);
        this.mFontColorAdapter = this.createDropDownNav(this.mFontColor, R.layout.rte_toolbar_fontcolor_spinner, R.layout.rte_toolbar_fontcolor_spinner_item, this.getFontColorItems(), this.mFontColorListener);
        this.mBGColor = (Spinner)this.findViewById(R.id.toolbar_bgcolor);
        this.mBGColorAdapter = this.createDropDownNav(this.mBGColor, R.layout.rte_toolbar_bgcolor_spinner, R.layout.rte_toolbar_bgcolor_spinner_item, this.getBGColorItems(), this.mBGColorListener);
    }

    private RTToolbarImageButton initImageButton(int id2) {
        RTToolbarImageButton button = (RTToolbarImageButton)this.findViewById(id2);
        if (button != null) {
            button.setOnClickListener(this);
        }
        return button;
    }

    private SpinnerItems<FontSpinnerItem> getFontItems() {
        SortedSet fonts = FontManager.getFonts((Context)this.getContext());
        SpinnerItems<FontSpinnerItem> spinnerItems = new SpinnerItems<FontSpinnerItem>();
        spinnerItems.add(new FontSpinnerItem(null));
        for (RTTypeface typeface : fonts) {
            spinnerItems.add(new FontSpinnerItem(typeface));
        }
        return spinnerItems;
    }

    private SpinnerItems<FontSizeSpinnerItem> getTextSizeItems() {
        SpinnerItems<FontSizeSpinnerItem> spinnerItems = new SpinnerItems<FontSizeSpinnerItem>();
        Resources res = this.getResources();
        spinnerItems.add(new FontSizeSpinnerItem(-1, "", true));
        String[] fontSizeEntries = res.getStringArray(R.array.rte_toolbar_fontsizes_entries);
        int[] fontSizeValues = res.getIntArray(R.array.rte_toolbar_fontsizes_values);
        for (int i = 0; i < fontSizeEntries.length; ++i) {
            spinnerItems.add(new FontSizeSpinnerItem(fontSizeValues[i], fontSizeEntries[i], false));
        }
        return spinnerItems;
    }

    private SpinnerItems<FontColorSpinnerItem> getFontColorItems() {
        SpinnerItems<FontColorSpinnerItem> spinnerItems = new SpinnerItems<FontColorSpinnerItem>();
        Context context = this.getContext();
        String name = context.getString(R.string.rte_toolbar_color_text);
        FontColorSpinnerItem spinnerItem = new FontColorSpinnerItem(this.mCustomColorFont, name, true, false);
        spinnerItems.add(spinnerItem);
        for (String fontColor : this.getResources().getStringArray(R.array.rte_toolbar_fontcolors_values)) {
            int color2 = Integer.parseInt(fontColor, 16);
            spinnerItem = new FontColorSpinnerItem(color2, name, false, false);
            spinnerItems.add(spinnerItem);
        }
        name = context.getString(R.string.rte_toolbar_color_custom);
        spinnerItem = new FontColorSpinnerItem(this.mCustomColorFont, name, false, true);
        spinnerItems.add(spinnerItem);
        return spinnerItems;
    }

    private SpinnerItems<BGColorSpinnerItem> getBGColorItems() {
        SpinnerItems<BGColorSpinnerItem> spinnerItems = new SpinnerItems<BGColorSpinnerItem>();
        Context context = this.getContext();
        String name = context.getString(R.string.rte_toolbar_color_text);
        BGColorSpinnerItem spinnerItem = new BGColorSpinnerItem(this.mCustomColorFont, name, true, false);
        spinnerItems.add(spinnerItem);
        for (String fontColor : this.getResources().getStringArray(R.array.rte_toolbar_fontcolors_values)) {
            int color2 = Integer.parseInt(fontColor, 16);
            spinnerItem = new BGColorSpinnerItem(color2, name, false, false);
            spinnerItems.add(spinnerItem);
        }
        name = context.getString(R.string.rte_toolbar_color_custom);
        spinnerItem = new BGColorSpinnerItem(this.mCustomColorFont, name, false, true);
        spinnerItems.add(spinnerItem);
        return spinnerItems;
    }

    private <T extends SpinnerItem> SpinnerItemAdapter<T> createDropDownNav(Spinner spinner, int spinnerId, int spinnerItemId, SpinnerItems<T> spinnerItems, final DropDownNavListener<T> listener) {
        if (spinner != null) {
            Context context = this.getContext();
            final SpinnerItemAdapter<T> dropDownNavAdapter = new SpinnerItemAdapter<T>(context, spinnerItems, spinnerId, spinnerItemId);
            spinner.setPadding(spinner.getPaddingLeft(), 0, spinner.getPaddingRight(), 0);
            spinner.setAdapter(dropDownNavAdapter);
            spinner.setSelection(spinnerItems.getSelectedItem());
            spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){
                private AtomicBoolean mFirstCall = new AtomicBoolean(true);

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    if (!this.mFirstCall.getAndSet(false) && dropDownNavAdapter.getSelectedItem() != position) {
                        listener.onItemSelected(dropDownNavAdapter.getItem(position), position);
                    }
                    dropDownNavAdapter.setSelectedItem(position);
                }

                public void onNothingSelected(AdapterView<?> parent) {
                }
            });
            return dropDownNavAdapter;
        }
        return null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mColorPickerListener != null && this.mPickerId != -1) {
            SetColorPickerListenerEvent.setListener((int)this.mPickerId, (ColorPickerListener)this.mColorPickerListener);
        }
    }

    public void setToolbarContainer(ViewGroup toolbarContainer) {
        this.mToolbarContainer = toolbarContainer;
    }

    public ViewGroup getToolbarContainer() {
        return this.mToolbarContainer == null ? this : this.mToolbarContainer;
    }

    public void setToolbarListener(RTToolbarListener listener) {
        this.mListener = listener;
    }

    public void removeToolbarListener() {
        this.mListener = null;
    }

    public int getId() {
        return this.mId;
    }

    public void setBold(boolean enabled) {
        if (this.mBold != null) {
            this.mBold.setChecked(enabled);
        }
    }

    public void setItalic(boolean enabled) {
        if (this.mItalic != null) {
            this.mItalic.setChecked(enabled);
        }
    }

    public void setUnderline(boolean enabled) {
        if (this.mUnderline != null) {
            this.mUnderline.setChecked(enabled);
        }
    }

    public void setStrikethrough(boolean enabled) {
        if (this.mStrikethrough != null) {
            this.mStrikethrough.setChecked(enabled);
        }
    }

    public void setSuperscript(boolean enabled) {
        if (this.mSuperscript != null) {
            this.mSuperscript.setChecked(enabled);
        }
    }

    public void setSubscript(boolean enabled) {
        if (this.mSubscript != null) {
            this.mSubscript.setChecked(enabled);
        }
    }

    public void setBullet(boolean enabled) {
        if (this.mBullet != null) {
            this.mBullet.setChecked(enabled);
        }
    }

    public void setNumber(boolean enabled) {
        if (this.mNumber != null) {
            this.mNumber.setChecked(enabled);
        }
    }

    public void setAlignment(Layout.Alignment alignment) {
        if (this.mAlignLeft != null) {
            this.mAlignLeft.setChecked(alignment == Layout.Alignment.ALIGN_NORMAL);
        }
        if (this.mAlignCenter != null) {
            this.mAlignCenter.setChecked(alignment == Layout.Alignment.ALIGN_CENTER);
        }
        if (this.mAlignRight != null) {
            this.mAlignRight.setChecked(alignment == Layout.Alignment.ALIGN_OPPOSITE);
        }
    }

    public void setFont(RTTypeface typeface) {
        if (this.mFont != null) {
            if (typeface != null) {
                for (int pos = 0; pos < this.mFontAdapter.getCount(); ++pos) {
                    FontSpinnerItem item = (FontSpinnerItem)this.mFontAdapter.getItem(pos);
                    if (!typeface.equals((Object)item.getTypeface())) continue;
                    this.mFontAdapter.setSelectedItem(pos);
                    this.mFont.setSelection(pos);
                    break;
                }
            } else {
                this.mFontAdapter.setSelectedItem(0);
                this.mFont.setSelection(0);
            }
        }
    }

    public void setFontSize(int size) {
        if (this.mFontSize != null) {
            if (size <= 0) {
                this.mFontSizeAdapter.updateSpinnerTitle("");
                this.mFontSizeAdapter.setSelectedItem(0);
                this.mFontSize.setSelection(0);
            } else {
                size = Helper.convertSpToPx((int)size);
                this.mFontSizeAdapter.updateSpinnerTitle(Integer.toString(size));
                for (int pos = 0; pos < this.mFontSizeAdapter.getCount(); ++pos) {
                    FontSizeSpinnerItem item = (FontSizeSpinnerItem)this.mFontSizeAdapter.getItem(pos);
                    if (size != item.getFontSize()) continue;
                    this.mFontSizeAdapter.setSelectedItem(pos);
                    this.mFontSize.setSelection(pos);
                    break;
                }
            }
        }
    }

    public void setFontColor(int color2) {
        if (this.mFontColor != null) {
            this.setFontColor(color2, this.mFontColor, this.mFontColorAdapter);
        }
    }

    public void setBGColor(int color2) {
        if (this.mBGColor != null) {
            this.setFontColor(color2, this.mBGColor, this.mBGColorAdapter);
        }
    }

    public void removeFontColor() {
        if (this.mFontColor != null) {
            this.mFontColorAdapter.setSelectedItem(0);
            this.mFontColor.setSelection(0);
        }
    }

    public void removeBGColor() {
        if (this.mBGColor != null) {
            this.mBGColorAdapter.setSelectedItem(0);
            this.mBGColor.setSelection(0);
        }
    }

    private void setFontColor(int color2, Spinner spinner, SpinnerItemAdapter<? extends ColorSpinnerItem> adapter) {
        int color2Compare = color2 & 0xFFFFFF;
        for (int pos = 0; pos < adapter.getCount(); ++pos) {
            ColorSpinnerItem item = (ColorSpinnerItem)adapter.getItem(pos);
            if (item.isEmpty() || color2Compare != (item.getColor() & 0xFFFFFF)) continue;
            adapter.setSelectedItem(pos);
            spinner.setSelection(pos);
            break;
        }
    }

    public void onClick(View v) {
        if (this.mListener != null) {
            int id2 = v.getId();
            if (id2 == R.id.toolbar_bold) {
                this.mBold.setChecked(!this.mBold.isChecked());
                this.mListener.onEffectSelected(Effects.BOLD, (Object)this.mBold.isChecked());
            } else if (id2 == R.id.toolbar_italic) {
                this.mItalic.setChecked(!this.mItalic.isChecked());
                this.mListener.onEffectSelected(Effects.ITALIC, (Object)this.mItalic.isChecked());
            } else if (id2 == R.id.toolbar_underline) {
                this.mUnderline.setChecked(!this.mUnderline.isChecked());
                this.mListener.onEffectSelected(Effects.UNDERLINE, (Object)this.mUnderline.isChecked());
            } else if (id2 == R.id.toolbar_strikethrough) {
                this.mStrikethrough.setChecked(!this.mStrikethrough.isChecked());
                this.mListener.onEffectSelected(Effects.STRIKETHROUGH, (Object)this.mStrikethrough.isChecked());
            } else if (id2 == R.id.toolbar_superscript) {
                this.mSuperscript.setChecked(!this.mSuperscript.isChecked());
                this.mListener.onEffectSelected(Effects.SUPERSCRIPT, (Object)this.mSuperscript.isChecked());
                if (this.mSuperscript.isChecked() && this.mSubscript != null) {
                    this.mSubscript.setChecked(false);
                    this.mListener.onEffectSelected(Effects.SUBSCRIPT, (Object)this.mSubscript.isChecked());
                }
            } else if (id2 == R.id.toolbar_subscript) {
                this.mSubscript.setChecked(!this.mSubscript.isChecked());
                this.mListener.onEffectSelected(Effects.SUBSCRIPT, (Object)this.mSubscript.isChecked());
                if (this.mSubscript.isChecked() && this.mSuperscript != null) {
                    this.mSuperscript.setChecked(false);
                    this.mListener.onEffectSelected(Effects.SUPERSCRIPT, (Object)this.mSuperscript.isChecked());
                }
            } else if (id2 == R.id.toolbar_align_left) {
                if (this.mAlignLeft != null) {
                    this.mAlignLeft.setChecked(true);
                }
                if (this.mAlignCenter != null) {
                    this.mAlignCenter.setChecked(false);
                }
                if (this.mAlignRight != null) {
                    this.mAlignRight.setChecked(false);
                }
                this.mListener.onEffectSelected((Effect)Effects.ALIGNMENT, (Object)Layout.Alignment.ALIGN_NORMAL);
            } else if (id2 == R.id.toolbar_align_center) {
                if (this.mAlignLeft != null) {
                    this.mAlignLeft.setChecked(false);
                }
                if (this.mAlignCenter != null) {
                    this.mAlignCenter.setChecked(true);
                }
                if (this.mAlignRight != null) {
                    this.mAlignRight.setChecked(false);
                }
                this.mListener.onEffectSelected((Effect)Effects.ALIGNMENT, (Object)Layout.Alignment.ALIGN_CENTER);
            } else if (id2 == R.id.toolbar_align_right) {
                if (this.mAlignLeft != null) {
                    this.mAlignLeft.setChecked(false);
                }
                if (this.mAlignCenter != null) {
                    this.mAlignCenter.setChecked(false);
                }
                if (this.mAlignRight != null) {
                    this.mAlignRight.setChecked(true);
                }
                this.mListener.onEffectSelected((Effect)Effects.ALIGNMENT, (Object)Layout.Alignment.ALIGN_OPPOSITE);
            } else if (id2 == R.id.toolbar_bullet) {
                this.mBullet.setChecked(!this.mBullet.isChecked());
                boolean isChecked = this.mBullet.isChecked();
                this.mListener.onEffectSelected((Effect)Effects.BULLET, (Object)isChecked);
                if (isChecked && this.mNumber != null) {
                    this.mNumber.setChecked(false);
                }
            } else if (id2 == R.id.toolbar_number) {
                this.mNumber.setChecked(!this.mNumber.isChecked());
                boolean isChecked = this.mNumber.isChecked();
                this.mListener.onEffectSelected((Effect)Effects.NUMBER, (Object)isChecked);
                if (isChecked && this.mBullet != null) {
                    this.mBullet.setChecked(false);
                }
            } else if (id2 == R.id.toolbar_inc_indent) {
                this.mListener.onEffectSelected((Effect)Effects.INDENTATION, (Object)Helper.getLeadingMarging());
            } else if (id2 == R.id.toolbar_dec_indent) {
                this.mListener.onEffectSelected((Effect)Effects.INDENTATION, (Object)(-Helper.getLeadingMarging()));
            } else if (id2 == R.id.toolbar_link) {
                this.mListener.onCreateLink();
            } else if (id2 == R.id.toolbar_image) {
                this.mListener.onPickImage();
            } else if (id2 == R.id.toolbar_image_capture) {
                this.mListener.onCaptureImage();
            } else if (id2 == R.id.toolbar_clear) {
                this.mListener.onClearFormatting();
            } else if (id2 == R.id.toolbar_undo) {
                this.mListener.onUndo();
            } else if (id2 == R.id.toolbar_redo) {
                this.mListener.onRedo();
            }
        }
    }

    static interface DropDownNavListener<T extends SpinnerItem> {
        public void onItemSelected(T var1, int var2);
    }
}

