/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.api;

import android.app.Activity;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.util.AndroidRuntimeException;
import android.widget.Toast;
import com.onegravity.rteditor.api.RTApi;
import com.onegravity.rteditor.api.RTProxy;
import java.lang.ref.SoftReference;

public class RTProxyImpl
implements RTProxy {
    private final SoftReference<Activity> mActivity;

    public RTProxyImpl(Activity activity) {
        this.mActivity = new SoftReference<Activity>(activity);
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.startActivityForResult(intent, requestCode);
        }
    }

    @Override
    public void runOnUiThread(Runnable action) {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.runOnUiThread(action);
        }
    }

    @Override
    public Toast makeText(int resId, int duration) {
        return Toast.makeText((Context)RTApi.getApplicationContext(), (int)resId, (int)duration);
    }

    @Override
    public Toast makeText(CharSequence text, int duration) {
        return Toast.makeText((Context)RTApi.getApplicationContext(), (CharSequence)text, (int)duration);
    }

    @Override
    public void openDialogFragment(String fragmentTag, DialogFragment fragment) {
        Activity activity = this.getActivity();
        if (activity != null) {
            FragmentManager fragmentMgr = activity.getFragmentManager();
            FragmentTransaction ft = fragmentMgr.beginTransaction();
            DialogFragment oldFragment = (DialogFragment)fragmentMgr.findFragmentByTag(fragmentTag);
            if (oldFragment == null) {
                fragment.show(ft, fragmentTag);
            }
        }
    }

    @Override
    public void removeFragment(String fragmentTag) {
        Activity activity = this.getActivity();
        if (activity != null) {
            FragmentManager fragmentMgr = activity.getFragmentManager();
            Fragment fragment = fragmentMgr.findFragmentByTag(fragmentTag);
            fragmentMgr.beginTransaction().remove(fragment).commit();
        }
    }

    private Activity getActivity() {
        if (this.mActivity == null && this.mActivity.get() == null) {
            throw new IncorrectInitializationException("The RTApi was't initialized correctly or the Activity was released by Android (SoftReference)");
        }
        return this.mActivity.get();
    }

    private static class IncorrectInitializationException
    extends AndroidRuntimeException {
        private static final long serialVersionUID = 327389536289485672L;

        public IncorrectInitializationException(String msg) {
            super(msg);
        }
    }
}

