/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter;

import android.text.Layout;
import android.text.style.ParagraphStyle;
import com.onegravity.rteditor.spans.AlignmentSpan;
import com.onegravity.rteditor.spans.BulletSpan;
import com.onegravity.rteditor.spans.IndentationSpan;
import com.onegravity.rteditor.spans.NumberSpan;

public enum ParagraphType {
    NONE("", "", "", "", false, false),
    ALIGNMENT_LEFT("<div align=\"left\">", "</div>", "", "", true, true),
    ALIGNMENT_CENTER("<div align=\"center\">", "</div>", "", "", true, true),
    ALIGNMENT_RIGHT("<div align=\"right\">", "</div>", "", "", true, true),
    BULLET("<ul>", "</ul>", "<li>", "</li>", false, true),
    NUMBERING("<ol>", "</ol>", "<li>", "</li>", false, true),
    INDENTATION_UL("<ul style='list-style-type:none;'>", "</ul>", "<li style='list-style-type:none;'>", "</li>", false, true),
    INDENTATION_OL("<ol style='list-style-type:none;'>", "</ol>", "<li style='list-style-type:none;'>", "</li>", false, true);

    private final String mStartTag;
    private final String mEndTag;
    private final boolean mIsAlignment;
    private final String mListStartTag;
    private final String mListEndTag;
    private final boolean mEndTagAddsLineBreak;

    public static ParagraphType getInstance(ParagraphStyle style) {
        if (style instanceof AlignmentSpan) {
            Layout.Alignment align = ((AlignmentSpan)style).getValue();
            return align == Layout.Alignment.ALIGN_NORMAL ? ALIGNMENT_LEFT : (align == Layout.Alignment.ALIGN_CENTER ? ALIGNMENT_CENTER : ALIGNMENT_RIGHT);
        }
        return style instanceof BulletSpan ? BULLET : (style instanceof NumberSpan ? NUMBERING : (style instanceof IndentationSpan ? INDENTATION_UL : null));
    }

    private ParagraphType(String startTag, String endTag, String listStartTag, String listEndTag, boolean isAlignment, boolean endTagAddsLineBreak) {
        this.mStartTag = startTag;
        this.mEndTag = endTag;
        this.mListStartTag = listStartTag;
        this.mListEndTag = listEndTag;
        this.mIsAlignment = isAlignment;
        this.mEndTagAddsLineBreak = endTagAddsLineBreak;
    }

    public boolean isUndefined() {
        return this == NONE;
    }

    public boolean isAlignment() {
        return this.mIsAlignment;
    }

    public boolean isBullet() {
        return this == BULLET;
    }

    public boolean isNumbering() {
        return this == NUMBERING;
    }

    public boolean isIndentation() {
        return this == INDENTATION_UL || this == INDENTATION_OL;
    }

    public String getStartTag() {
        return this.mStartTag;
    }

    public String getEndTag() {
        return this.mEndTag;
    }

    public String getListStartTag() {
        return this.mListStartTag;
    }

    public String getListEndTag() {
        return this.mListEndTag;
    }

    public boolean endTagAddsLineBreak() {
        return this.mEndTagAddsLineBreak;
    }
}

