/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Editable;
import android.text.Spannable;
import android.widget.EditText;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.CharacterSpanCollector;
import com.onegravity.rteditor.effects.Effect;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.effects.SpanCollector;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Selection;

abstract class CharacterEffect<V, C extends RTSpan<V>>
extends Effect<V, C> {
    CharacterEffect() {
    }

    @Override
    protected final SpanCollector<V> newSpanCollector(Class<? extends RTSpan<V>> spanClazz) {
        return new CharacterSpanCollector(spanClazz);
    }

    @Override
    protected final Selection getSelection(RTEditText editor) {
        return new Selection((EditText)editor);
    }

    @Override
    public void applyToSelection(RTEditText editor, V value) {
        RTSpan<V> newSpan;
        Selection selection = this.getSelection(editor);
        int flags = selection.isEmpty() ? 18 : 34;
        Editable str = editor.getText();
        for (RTSpan span : this.getSpans((Spannable)str, selection, SpanCollectMode.SPAN_FLAGS)) {
            int spanEnd;
            boolean sameSpan = span.getValue().equals(value);
            int spanStart = str.getSpanStart(span);
            if (spanStart < selection.start()) {
                if (sameSpan) {
                    flags = 34;
                    selection.offset(selection.start() - spanStart, 0);
                } else {
                    str.setSpan(this.newSpan(span.getValue()), spanStart, selection.start(), 33);
                }
            }
            if ((spanEnd = str.getSpanEnd(span)) > selection.end()) {
                if (sameSpan) {
                    selection.offset(0, spanEnd - selection.end());
                } else {
                    str.setSpan(this.newSpan(span.getValue()), selection.end(), spanEnd, 34);
                }
            }
            str.removeSpan(span);
        }
        if (value != null && (newSpan = this.newSpan(value)) != null) {
            str.setSpan(newSpan, selection.start(), selection.end(), flags);
        }
    }

    protected abstract RTSpan<V> newSpan(V var1);
}

