/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.choose;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.media.MediaUtils;
import com.onegravity.rteditor.media.MonitoredActivity;
import com.onegravity.rteditor.media.choose.MediaChooserManager;
import com.onegravity.rteditor.media.choose.processor.ImageProcessor;
import com.onegravity.rteditor.utils.Constants;
import java.io.File;

class ImageChooserManager
extends MediaChooserManager
implements ImageProcessor.ImageProcessorListener {
    private static final String CAPTURED_IMAGE_TEMPLATE = "CAPTURED_IMAGE.jpeg";
    private ImageChooserListener mListener;

    ImageChooserManager(MonitoredActivity activity, Constants.MediaAction mediaAction, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory, ImageChooserListener listener, Bundle savedInstanceState) {
        super(activity, mediaAction, mediaFactory, listener, savedInstanceState);
        this.mListener = listener;
    }

    @Override
    boolean chooseMedia() throws IllegalArgumentException {
        if (this.mListener == null) {
            throw new IllegalArgumentException("ImageChooserListener cannot be null");
        }
        switch (this.mMediaAction) {
            case PICK_PICTURE: {
                return this.pickPicture();
            }
            case CAPTURE_PICTURE: {
                return this.takePicture();
            }
        }
        return false;
    }

    private boolean pickPicture() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT", null).addCategory("android.intent.category.OPENABLE").setType("image/*");
        String title = this.mActivity.getString(R.string.rte_pick_image);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)title));
        return true;
    }

    private boolean takePicture() {
        try {
            File imagePath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            File imageFile = MediaUtils.createUniqueFile(imagePath, CAPTURED_IMAGE_TEMPLATE, false);
            imagePath.mkdirs();
            if (!imagePath.exists() || !imageFile.createNewFile()) {
                Toast.makeText((Context)this.mActivity, (CharSequence)"Can't take picture without an sdcard", (int)0).show();
                return false;
            }
            this.setOriginalFile(imageFile.getAbsolutePath());
            Uri uriForCamera = Build.VERSION.SDK_INT < 21 ? Uri.fromFile((File)imageFile) : FileProvider.getUriForFile((Context)this.mActivity, (String)(this.mActivity.getPackageName() + ".provider"), (File)imageFile);
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE").putExtra("output", (Parcelable)uriForCamera);
            this.startActivity(intent);
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    void processMedia(Constants.MediaAction mediaAction, Intent data) {
        switch (mediaAction) {
            case PICK_PICTURE: {
                String originalFile = this.determineOriginalFile(data);
                if (originalFile == null) break;
                ImageProcessor processor = new ImageProcessor(originalFile, (RTMediaFactory<RTImage, RTAudio, RTVideo>)this.mMediaFactory, this);
                this.startBackgroundJob(processor);
                break;
            }
            case CAPTURE_PICTURE: {
                String originalFile = this.getOriginalFile();
                if (originalFile == null) break;
                ImageProcessor processor = new ImageProcessor(originalFile, (RTMediaFactory<RTImage, RTAudio, RTVideo>)this.mMediaFactory, this);
                this.startBackgroundJob(processor);
                break;
            }
        }
    }

    @Override
    public void onImageProcessed(RTImage image) {
        if (this.mListener != null) {
            this.mListener.onImageChosen(image);
        }
    }

    public static interface ImageChooserListener
    extends MediaChooserManager.MediaChooserListener {
        public void onImageChosen(RTImage var1);
    }
}

