/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.choose.processor;

import android.content.ContentResolver;
import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.onegravity.rteditor.api.RTApi;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.utils.io.FilenameUtils;
import com.onegravity.rteditor.utils.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class MediaProcessor
implements Runnable {
    private final MediaProcessorListener mListener;
    private final String mOriginalFile;
    protected final RTMediaFactory<RTImage, RTAudio, RTVideo> mMediaFactory;

    public MediaProcessor(String originalFile, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory, MediaProcessorListener listener) {
        this.mOriginalFile = originalFile;
        this.mMediaFactory = mediaFactory;
        this.mListener = listener;
    }

    @Override
    public final void run() {
        block2: {
            try {
                this.processMedia();
            }
            catch (Exception e) {
                if (this.mListener == null) break block2;
                this.mListener.onError(e.getMessage());
            }
        }
    }

    protected String getOriginalFile() {
        return this.mOriginalFile;
    }

    protected abstract void processMedia() throws IOException, Exception;

    protected InputStream getInputStream() throws IOException, Exception {
        InputStream in = null;
        in = this.mOriginalFile.startsWith("http") ? this.downloadFile(this.mOriginalFile) : (this.mOriginalFile.startsWith("content://") ? this.processContentProviderMedia(this.mOriginalFile) : this.copyFileToDir(this.mOriginalFile));
        return in;
    }

    protected String getMimeType() throws IOException, Exception {
        if (this.mOriginalFile.startsWith("content://")) {
            ContentResolver resolver = RTApi.getApplicationContext().getContentResolver();
            Uri uri = Uri.parse((String)this.mOriginalFile);
            return resolver.getType(uri);
        }
        String extension = FilenameUtils.getExtension(this.mOriginalFile);
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }

    private InputStream copyFileToDir(String sourceFile) {
        FileInputStream in = null;
        try {
            File fileFrom = new File(Uri.parse((String)sourceFile).getPath());
            in = new FileInputStream(fileFrom);
        }
        catch (IOException e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
        }
        return in;
    }

    private InputStream downloadFile(String sourceFile) {
        BufferedInputStream in = null;
        try {
            URL url = new URL(sourceFile);
            final HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            in = new BufferedInputStream(urlConnection.getInputStream()){

                @Override
                public void close() throws IOException {
                    super.close();
                    urlConnection.disconnect();
                }
            };
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
            IOUtils.closeQuietly(in);
        }
        return in;
    }

    private InputStream processContentProviderMedia(String sourceFile) {
        ContentResolver resolver = RTApi.getApplicationContext().getContentResolver();
        Uri uri = Uri.parse((String)sourceFile);
        InputStream in = null;
        try {
            in = resolver.openInputStream(uri);
        }
        catch (IOException ioe) {
            Log.e((String)this.getClass().getSimpleName(), (String)ioe.getMessage(), (Throwable)ioe);
        }
        return in;
    }

    public static interface MediaProcessorListener {
        public void onError(String var1);
    }
}

