/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.utils;

import com.onegravity.rteditor.utils.Selection;

public class Paragraph
extends Selection {
    private static final long serialVersionUID = 2475227150049924994L;
    private final boolean mIsFirst;
    private final boolean mIsLast;

    public Paragraph(int start, int end, boolean isFirst, boolean isLast) {
        super(start, end);
        this.mIsFirst = isFirst;
        this.mIsLast = isLast;
    }

    public boolean isFirst() {
        return this.mIsFirst;
    }

    public boolean isLast() {
        return this.mIsLast;
    }

    public boolean isSelected(Selection sel) {
        int end;
        if (sel == null) {
            return false;
        }
        if (sel.isEmpty()) {
            boolean isCompletelyWithin = sel.start() >= this.start() && sel.end() < this.end();
            boolean isWithin = sel.start() >= this.start() && sel.end() <= this.end();
            return isCompletelyWithin || isWithin && this.mIsLast;
        }
        int start = Math.max(this.start(), sel.start());
        return start < (end = Math.min(this.end(), sel.end()));
    }
}

