/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.validator.EmailValidator;
import com.onegravity.rteditor.utils.validator.UrlValidator;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;

public class LinkFragment
extends DialogFragment {
    private static final String LINK_ADDRESS = "link_address";
    private static final String LINK_TEXT = "link_text";
    private static final UrlValidator sUrlValidator = new UrlValidator(3L);
    private static final EmailValidator sEmailValidator = EmailValidator.getInstance(false);

    public static LinkFragment newInstance(String linkText, String url) {
        LinkFragment fragment = new LinkFragment();
        Bundle args = new Bundle();
        args.putString(LINK_TEXT, linkText);
        args.putString(LINK_ADDRESS, url);
        fragment.setArguments(args);
        return fragment;
    }

    @SuppressLint(value={"InflateParams"})
    public final Dialog onCreateDialog(Bundle savedInstanceState) {
        Activity context = this.getActivity();
        LayoutInflater li = LayoutInflater.from((Context)context);
        View view = li.inflate(R.layout.rte_link, null);
        Bundle args = this.getArguments();
        String tmp = "http://";
        String address = args.getString(LINK_ADDRESS);
        if (address != null && !address.isEmpty()) {
            try {
                Uri uri = Uri.parse((String)Helper.decodeQuery(address));
                tmp = this.startsWithMailto(address) ? uri.getSchemeSpecificPart() : uri.toString();
            }
            catch (Exception uri) {
                // empty catch block
            }
        }
        String url = tmp;
        TextView addressView = (TextView)view.findViewById(R.id.linkURL);
        if (url != null) {
            addressView.setText((CharSequence)url);
        }
        String linkText = args.getString(LINK_TEXT);
        TextView textView = (TextView)view.findViewById(R.id.linkText);
        if (linkText != null) {
            textView.setText((CharSequence)linkText);
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context).setTitle(R.string.rte_create_a_link).setView(view).setCancelable(false).setPositiveButton(17039370, null).setNegativeButton(0x1040000, (dialog, which) -> EventBus.getDefault().post((Object)new LinkEvent((Fragment)this, new Link(null, url), true)));
        if (address != null) {
            builder.setNeutralButton(R.string.rte_remove_action, (dialog, which) -> EventBus.getDefault().post((Object)new LinkEvent((Fragment)this, null, false)));
        }
        AlertDialog dialog2 = builder.create();
        dialog2.setOnShowListener(arg_0 -> this.lambda$onCreateDialog$3(addressView, textView, (Dialog)dialog2, arg_0));
        return dialog2;
    }

    private boolean validate(TextView addressView, TextView textView) {
        String address = addressView.getText().toString().trim();
        boolean isEmail = sEmailValidator.isValid(address);
        boolean isUrl = sUrlValidator.isValid(address);
        if (this.requiredFieldValid(addressView) && (isUrl || isEmail)) {
            String linkText;
            String newAddress = Helper.encodeUrl(address);
            if (isEmail && !this.startsWithMailto(newAddress)) {
                newAddress = "mailto:" + newAddress;
            }
            if ((linkText = textView.getText().toString()).length() == 0) {
                linkText = address;
            }
            EventBus.getDefault().post((Object)new LinkEvent((Fragment)this, new Link(linkText, newAddress), false));
            return true;
        }
        String errorMessage = this.getString(R.string.rte_invalid_link, new Object[]{address});
        addressView.setError((CharSequence)errorMessage);
        return false;
    }

    private boolean startsWithMailto(String address) {
        return address != null && address.toLowerCase(Locale.getDefault()).startsWith("mailto:");
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        EventBus.getDefault().post((Object)new LinkEvent((Fragment)this, null, true));
    }

    private boolean requiredFieldValid(TextView view) {
        return view.getText() != null && view.getText().length() > 0;
    }

    private /* synthetic */ void lambda$onCreateDialog$3(TextView addressView, TextView textView, Dialog dialog, DialogInterface dialogInterface) {
        ((AlertDialog)dialogInterface).getButton(-1).setOnClickListener(button -> {
            if (this.validate(addressView, textView)) {
                try {
                    dialog.dismiss();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static class LinkEvent {
        private final String mFragmentTag;
        private final Link mLink;
        private final boolean mWasCancelled;

        public LinkEvent(Fragment fragment, Link link, boolean wasCancelled) {
            this.mFragmentTag = fragment.getTag();
            this.mLink = link;
            this.mWasCancelled = wasCancelled;
        }

        public String getFragmentTag() {
            return this.mFragmentTag;
        }

        public Link getLink() {
            return this.mLink;
        }

        public boolean wasCancelled() {
            return this.mWasCancelled;
        }
    }

    static class Link {
        private final String mLinkText;
        private final String mUrl;

        private Link(String linkText, String url) {
            this.mLinkText = linkText;
            this.mUrl = url;
        }

        public String getLinkText() {
            return this.mLinkText;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public boolean isValid() {
            return this.mUrl != null && this.mUrl.length() > 0 && this.mLinkText != null && this.mLinkText.length() > 0;
        }
    }
}

