/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter.tagsoup;

import com.onegravity.rteditor.converter.tagsoup.ScanHandler;
import com.onegravity.rteditor.converter.tagsoup.Scanner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTMLScanner
implements Scanner,
Locator {
    private static final int S_ANAME = 1;
    private static final int S_APOS = 2;
    private static final int S_AVAL = 3;
    private static final int S_BB = 4;
    private static final int S_BBC = 5;
    private static final int S_BBCD = 6;
    private static final int S_BBCDA = 7;
    private static final int S_BBCDAT = 8;
    private static final int S_BBCDATA = 9;
    private static final int S_CDATA = 10;
    private static final int S_CDATA2 = 11;
    private static final int S_CDSECT = 12;
    private static final int S_CDSECT1 = 13;
    private static final int S_CDSECT2 = 14;
    private static final int S_COM = 15;
    private static final int S_COM2 = 16;
    private static final int S_COM3 = 17;
    private static final int S_COM4 = 18;
    private static final int S_DECL = 19;
    private static final int S_DECL2 = 20;
    private static final int S_DONE = 21;
    private static final int S_EMPTYTAG = 22;
    private static final int S_ENT = 23;
    private static final int S_EQ = 24;
    private static final int S_ETAG = 25;
    private static final int S_GI = 26;
    private static final int S_NCR = 27;
    private static final int S_PCDATA = 28;
    private static final int S_PI = 29;
    private static final int S_PITARGET = 30;
    private static final int S_QUOT = 31;
    private static final int S_STAGC = 32;
    private static final int S_TAG = 33;
    private static final int S_TAGWS = 34;
    private static final int S_XNCR = 35;
    private static final int A_ADUP = 1;
    private static final int A_ADUP_SAVE = 2;
    private static final int A_ADUP_STAGC = 3;
    private static final int A_ANAME = 4;
    private static final int A_ANAME_ADUP = 5;
    private static final int A_ANAME_ADUP_STAGC = 6;
    private static final int A_AVAL = 7;
    private static final int A_AVAL_STAGC = 8;
    private static final int A_CDATA = 9;
    private static final int A_CMNT = 10;
    private static final int A_DECL = 11;
    private static final int A_EMPTYTAG = 12;
    private static final int A_ENTITY = 13;
    private static final int A_ENTITY_START = 14;
    private static final int A_ETAG = 15;
    private static final int A_GI = 16;
    private static final int A_GI_STAGC = 17;
    private static final int A_LT = 18;
    private static final int A_LT_PCDATA = 19;
    private static final int A_MINUS = 20;
    private static final int A_MINUS2 = 21;
    private static final int A_MINUS3 = 22;
    private static final int A_PCDATA = 23;
    private static final int A_PI = 24;
    private static final int A_PITARGET = 25;
    private static final int A_PITARGET_PI = 26;
    private static final int A_SAVE = 27;
    private static final int A_SKIP = 28;
    private static final int A_SP = 29;
    private static final int A_STAGC = 30;
    private static final int A_UNGET = 31;
    private static final int A_UNSAVE_PCDATA = 32;
    private static int[] statetable = new int[]{1, 47, 5, 22, 1, 61, 4, 3, 1, 62, 6, 28, 1, 0, 27, 1, 1, -1, 6, 21, 1, 32, 4, 24, 1, 10, 4, 24, 1, 9, 4, 24, 2, 39, 7, 34, 2, 0, 27, 2, 2, -1, 8, 21, 2, 32, 29, 2, 2, 10, 29, 2, 2, 9, 29, 2, 3, 39, 28, 2, 3, 34, 28, 31, 3, 62, 8, 28, 3, 0, 27, 32, 3, -1, 8, 21, 3, 32, 28, 3, 3, 10, 28, 3, 3, 9, 28, 3, 4, 67, 28, 5, 4, 0, 28, 19, 4, -1, 28, 21, 5, 68, 28, 6, 5, 0, 28, 19, 5, -1, 28, 21, 6, 65, 28, 7, 6, 0, 28, 19, 6, -1, 28, 21, 7, 84, 28, 8, 7, 0, 28, 19, 7, -1, 28, 21, 8, 65, 28, 9, 8, 0, 28, 19, 8, -1, 28, 21, 9, 91, 28, 12, 9, 0, 28, 19, 9, -1, 28, 21, 10, 60, 27, 11, 10, 0, 27, 10, 10, -1, 23, 21, 11, 47, 32, 25, 11, 0, 27, 10, 11, -1, 32, 21, 12, 93, 27, 13, 12, 0, 27, 12, 12, -1, 28, 21, 13, 93, 27, 14, 13, 0, 27, 12, 13, -1, 28, 21, 14, 62, 9, 28, 14, 0, 27, 12, 14, -1, 28, 21, 15, 45, 28, 16, 15, 0, 27, 16, 15, -1, 10, 21, 16, 45, 28, 17, 16, 0, 27, 16, 16, -1, 10, 21, 17, 45, 28, 18, 17, 0, 20, 16, 17, -1, 10, 21, 18, 45, 22, 18, 18, 62, 10, 28, 18, 0, 21, 16, 18, -1, 10, 21, 19, 45, 28, 15, 19, 91, 28, 4, 19, 62, 28, 28, 19, 0, 27, 20, 19, -1, 28, 21, 20, 62, 11, 28, 20, 0, 27, 20, 20, -1, 28, 21, 22, 62, 12, 28, 22, 0, 27, 1, 22, 32, 28, 34, 22, 10, 28, 34, 22, 9, 28, 34, 23, 0, 13, 23, 23, -1, 13, 21, 24, 61, 28, 3, 24, 62, 3, 28, 24, 0, 2, 1, 24, -1, 3, 21, 24, 32, 28, 24, 24, 10, 28, 24, 24, 9, 28, 24, 25, 62, 15, 28, 25, 0, 27, 25, 25, -1, 15, 21, 25, 32, 28, 25, 25, 10, 28, 25, 25, 9, 28, 25, 26, 47, 28, 22, 26, 62, 17, 28, 26, 0, 27, 26, 26, -1, 28, 21, 26, 32, 16, 34, 26, 10, 16, 34, 26, 9, 16, 34, 27, 0, 13, 27, 27, -1, 13, 21, 28, 38, 14, 23, 28, 60, 23, 33, 28, 0, 27, 28, 28, -1, 23, 21, 29, 62, 24, 28, 29, 0, 27, 29, 29, -1, 24, 21, 30, 62, 26, 28, 30, 0, 27, 30, 30, -1, 26, 21, 30, 32, 25, 29, 30, 10, 25, 29, 30, 9, 25, 29, 31, 34, 7, 34, 31, 0, 27, 31, 31, -1, 8, 21, 31, 32, 29, 31, 31, 10, 29, 31, 31, 9, 29, 31, 32, 62, 8, 28, 32, 0, 27, 32, 32, -1, 8, 21, 32, 32, 7, 34, 32, 10, 7, 34, 32, 9, 7, 34, 33, 33, 28, 19, 33, 63, 28, 30, 33, 47, 28, 25, 33, 60, 27, 33, 33, 0, 27, 26, 33, -1, 19, 21, 33, 32, 18, 28, 33, 10, 18, 28, 33, 9, 18, 28, 34, 47, 28, 22, 34, 62, 30, 28, 34, 0, 27, 1, 34, -1, 30, 21, 34, 32, 28, 34, 34, 10, 28, 34, 34, 9, 28, 34, 35, 0, 13, 35, 35, -1, 13, 21};
    private String thePublicid;
    private String theSystemid;
    private int theLastLine;
    private int theLastColumn;
    private int theCurrentLine;
    private int theCurrentColumn;
    int theState;
    int theNextState;
    char[] theOutputBuffer = new char[200];
    int theSize;
    int[] theWinMap = new int[]{8364, 65533, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 65533, 381, 65533, 65533, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 65533, 382, 376};

    private void unread(PushbackReader r, int c) throws IOException {
        if (c != -1) {
            r.unread(c);
        }
    }

    @Override
    public int getLineNumber() {
        return this.theLastLine;
    }

    @Override
    public int getColumnNumber() {
        return this.theLastColumn;
    }

    @Override
    public String getPublicId() {
        return this.thePublicid;
    }

    @Override
    public String getSystemId() {
        return this.theSystemid;
    }

    @Override
    public void resetDocumentLocator(String publicid, String systemid) {
        this.thePublicid = publicid;
        this.theSystemid = systemid;
        this.theCurrentColumn = 0;
        this.theCurrentLine = 0;
        this.theLastColumn = 0;
        this.theLastLine = 0;
    }

    @Override
    public void scan(Reader r0, ScanHandler h) throws IOException, SAXException {
        this.theState = 28;
        PushbackReader r = r0 instanceof PushbackReader ? (PushbackReader)r0 : (r0 instanceof BufferedReader ? new PushbackReader(r0) : new PushbackReader(new BufferedReader(r0, 200)));
        int firstChar = r.read();
        if (firstChar != 65279) {
            this.unread(r, firstChar);
        }
        while (this.theState != 21) {
            String s;
            int c1 = r.read();
            char c = (char)c1;
            boolean is32BitChar = Character.isHighSurrogate(c);
            int c2 = is32BitChar ? r.read() : -1;
            String string2 = s = is32BitChar ? new StringBuffer().append(c).append((char)c2).toString() : null;
            if (!is32BitChar && c1 >= 128 && c1 <= 159) {
                c1 = this.theWinMap[c1 - 128];
            }
            if (!is32BitChar && c1 == 13 && (c1 = r.read()) != 10) {
                this.unread(r, c1);
                c1 = 10;
            }
            if (!is32BitChar && c1 == 10) {
                ++this.theCurrentLine;
                this.theCurrentColumn = 0;
            } else {
                ++this.theCurrentColumn;
            }
            if (is32BitChar && c1 < 32 && c1 != 10 && c1 != 9 && c1 != -1) continue;
            int action = 0;
            for (int i = 0; i < statetable.length; i += 4) {
                if (this.theState != statetable[i]) {
                    if (action == 0) continue;
                    break;
                }
                if (statetable[i + 1] == 0) {
                    action = statetable[i + 2];
                    this.theNextState = statetable[i + 3];
                    continue;
                }
                if (is32BitChar || statetable[i + 1] != c1) continue;
                action = statetable[i + 2];
                this.theNextState = statetable[i + 3];
                break;
            }
            switch (action) {
                case 0: {
                    throw new Error("HTMLScanner can't cope with " + Integer.toString(c1) + " in state " + Integer.toString(this.theState));
                }
                case 1: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 2: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    if (s == null) break;
                    this.save(s, c1, h);
                    break;
                }
                case 3: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 4: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 5: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 6: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 7: {
                    h.aval(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 8: {
                    h.aval(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 9: {
                    this.mark();
                    if (this.theSize > 1) {
                        this.theSize -= 2;
                    }
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 14: {
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    this.save(s, c1, h);
                    break;
                }
                case 13: {
                    this.mark();
                    if (this.theState == 23 && c == '#') {
                        this.theNextState = 27;
                        this.save(s, c1, h);
                        break;
                    }
                    if (this.theState == 27 && (c == 'x' || c == 'X')) {
                        this.theNextState = 35;
                        this.save(s, c1, h);
                        break;
                    }
                    if (this.theState == 23 && Character.isLetterOrDigit(c)) {
                        this.save(s, c1, h);
                        break;
                    }
                    if (this.theState == 27 && Character.isDigit(c)) {
                        this.save(s, c1, h);
                        break;
                    }
                    if (this.theState == 35 && (Character.isDigit(c) || "abcdefABCDEF".indexOf(c) != -1)) {
                        this.save(s, c1, h);
                        break;
                    }
                    h.entity(this.theOutputBuffer, 1, this.theSize - 1);
                    int ent = h.getEntity();
                    if (ent != 0) {
                        this.theSize = 0;
                        if (ent >= 128 && ent <= 159) {
                            ent = this.theWinMap[ent - 128];
                        }
                        if (ent < 32) {
                            ent = 32;
                        } else if (ent >= 55296 && ent <= 57343) {
                            ent = 0;
                        } else if (ent <= 65535) {
                            this.save(ent, h);
                        } else {
                            this.save(((ent -= 65536) >> 10) + 55296, h);
                            this.save((ent & 0x3FF) + 56320, h);
                        }
                        if (is32BitChar || c1 != 59) {
                            if (is32BitChar) {
                                this.unread(r, c2);
                                --this.theCurrentColumn;
                            }
                            this.unread(r, c1);
                            --this.theCurrentColumn;
                        }
                    } else {
                        if (is32BitChar) {
                            this.unread(r, c2);
                            --this.theCurrentColumn;
                        }
                        this.unread(r, c1);
                        --this.theCurrentColumn;
                    }
                    this.theNextState = 28;
                    break;
                }
                case 15: {
                    h.etag(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 11: {
                    h.decl(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 16: {
                    h.gi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 17: {
                    h.gi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 18: {
                    this.mark();
                    this.save(60, h);
                    this.save(s, c1, h);
                    break;
                }
                case 19: {
                    this.mark();
                    this.save(60, h);
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 23: {
                    this.mark();
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 10: {
                    this.mark();
                    h.cmnt(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 22: {
                    this.save(45, h);
                    this.save(32, h);
                    break;
                }
                case 21: {
                    this.save(45, h);
                    this.save(32, h);
                }
                case 20: {
                    this.save(45, h);
                    this.save(s, c1, h);
                    break;
                }
                case 24: {
                    this.mark();
                    h.pi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 25: {
                    h.pitarget(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 26: {
                    h.pitarget(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.pi(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 27: {
                    this.save(s, c1, h);
                    break;
                }
                case 28: {
                    break;
                }
                case 29: {
                    this.save(32, h);
                    break;
                }
                case 30: {
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 12: {
                    this.mark();
                    if (this.theSize > 0) {
                        h.gi(this.theOutputBuffer, 0, this.theSize);
                    }
                    this.theSize = 0;
                    h.stage(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 31: {
                    this.unread(r, c1);
                    --this.theCurrentColumn;
                    break;
                }
                case 32: {
                    if (this.theSize > 0) {
                        --this.theSize;
                    }
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                default: {
                    throw new Error("Can't process state " + action);
                }
            }
            this.theState = this.theNextState;
        }
        h.eof(this.theOutputBuffer, 0, 0);
    }

    private void mark() {
        this.theLastColumn = this.theCurrentColumn;
        this.theLastLine = this.theCurrentLine;
    }

    @Override
    public void startCDATA() {
        this.theNextState = 10;
    }

    private void save(int ch, ScanHandler h) throws IOException, SAXException {
        this.save(h);
        this.theOutputBuffer[this.theSize++] = (char)ch;
    }

    private void save(String s, int ch, ScanHandler h) throws IOException, SAXException {
        if (s == null) {
            this.save(ch, h);
        } else {
            this.save(h);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.theOutputBuffer[this.theSize++] = s.charAt(i);
            }
        }
    }

    private void save(ScanHandler h) throws IOException, SAXException {
        if (this.theSize >= this.theOutputBuffer.length - 20) {
            if (this.theState == 28 || this.theState == 10) {
                h.pcdata(this.theOutputBuffer, 0, this.theSize);
                this.theSize = 0;
            } else {
                char[] newOutputBuffer = new char[this.theOutputBuffer.length * 2];
                System.arraycopy(this.theOutputBuffer, 0, newOutputBuffer, 0, this.theSize + 1);
                this.theOutputBuffer = newOutputBuffer;
            }
        }
    }
}

