/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.fonts;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import com.onegravity.rteditor.fonts.AssetIndex;
import com.onegravity.rteditor.fonts.RTTypeface;
import com.onegravity.rteditor.fonts.RTTypefaceSet;
import com.onegravity.rteditor.fonts.TTFAnalyzer;
import com.onegravity.rteditor.utils.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

public class FontManager {
    private static final String[] FONT_DIRS = new String[]{"/system/fonts", "/system/font", "/data/fonts"};
    private static final Map<String, String> ASSET_FONTS_BY_NAME = new TreeMap<String, String>();
    private static final Map<String, String> SYSTEM_FONTS_BY_PATH = new TreeMap<String, String>();
    private static final Map<String, String> SYSTEM_FONTS_BY_NAME = new TreeMap<String, String>();
    private static final RTTypefaceSet ALL_FONTS = new RTTypefaceSet(){

        @Override
        RTTypeface get(String fontName) {
            for (RTTypeface typeface : this) {
                if (!typeface.getName().equals(fontName)) continue;
                return typeface;
            }
            return null;
        }

        @Override
        boolean contains(String fontName) {
            return this.get(fontName) != null;
        }
    };

    public static void preLoadFonts(Context context) {
        new Thread(() -> {
            Map<String, String> map = ASSET_FONTS_BY_NAME;
            synchronized (map) {
                FontManager.getAssetFonts(context);
            }
            map = SYSTEM_FONTS_BY_NAME;
            synchronized (map) {
                FontManager.getSystemFonts();
            }
        }).start();
    }

    public static SortedSet<RTTypeface> getFonts(Context context) {
        Map<String, String> assetFonts = FontManager.getAssetFonts(context);
        AssetManager assets = context.getResources().getAssets();
        for (String fontName : assetFonts.keySet()) {
            String filePath = assetFonts.get(fontName);
            if (ALL_FONTS.contains(fontName)) continue;
            try {
                Typeface typeface = Typeface.createFromAsset((AssetManager)assets, (String)filePath);
                ALL_FONTS.add(new RTTypeface(fontName, typeface));
            }
            catch (Exception typeface) {}
        }
        Map<String, String> systemFonts = FontManager.getSystemFonts();
        for (String fontName : systemFonts.keySet()) {
            String filePath = systemFonts.get(fontName);
            if (ALL_FONTS.contains(fontName)) continue;
            try {
                Typeface typeface = Typeface.createFromFile((String)filePath);
                ALL_FONTS.add(new RTTypeface(fontName, typeface));
            }
            catch (Exception exception) {}
        }
        return ALL_FONTS;
    }

    public static RTTypeface getTypeface(String fontName) {
        return ALL_FONTS.get(fontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getAssetFonts(Context context) {
        Map<String, String> map = ASSET_FONTS_BY_NAME;
        synchronized (map) {
            if (ASSET_FONTS_BY_NAME.isEmpty()) {
                AssetManager assets = context.getResources().getAssets();
                Collection<String> fontFiles = AssetIndex.getAssetIndex(context);
                if (fontFiles == null || fontFiles.isEmpty()) {
                    fontFiles = FontManager.listFontFiles(context.getResources());
                }
                for (String filePath : fontFiles) {
                    if (!filePath.toLowerCase(Locale.getDefault()).endsWith("ttf")) continue;
                    String fontName = TTFAnalyzer.getFontName(assets, filePath);
                    if (fontName == null) {
                        fontName = FontManager.getFileName(filePath);
                    }
                    ASSET_FONTS_BY_NAME.put(fontName, filePath);
                }
            }
            return ASSET_FONTS_BY_NAME;
        }
    }

    private static Collection<String> listFontFiles(Resources res) {
        ArrayList<String> fonts = new ArrayList<String>();
        FontManager.listFontFiles(res.getAssets(), fonts, "", 0);
        return fonts;
    }

    private static void listFontFiles(AssetManager assets, Collection<String> fonts, String path, int level) {
        if (level >= 8) {
            return;
        }
        try {
            String[] list = assets.list(path);
            if (list != null && list.length > 0) {
                for (String file : list) {
                    String prefix = "".equals(path) ? "" : path + File.separator;
                    FontManager.listFontFiles(assets, fonts, prefix + file, ++level);
                }
            } else if (path.endsWith("ttf")) {
                fonts.add(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getSystemFonts() {
        Map<String, String> map = SYSTEM_FONTS_BY_NAME;
        synchronized (map) {
            for (String fontDir : FONT_DIRS) {
                File[] files;
                File dir = new File(fontDir);
                if (!dir.exists() || (files = dir.listFiles()) == null) continue;
                for (File file : files) {
                    String filePath = file.getAbsolutePath();
                    if (SYSTEM_FONTS_BY_PATH.containsKey(filePath)) continue;
                    String fontName = TTFAnalyzer.getFontName(file.getAbsolutePath());
                    if (fontName == null) {
                        fontName = FontManager.getFileName(filePath);
                    }
                    SYSTEM_FONTS_BY_PATH.put(filePath, fontName);
                    SYSTEM_FONTS_BY_NAME.put(fontName, filePath);
                }
            }
            return SYSTEM_FONTS_BY_NAME;
        }
    }

    private static String getFileName(String path) {
        return FilenameUtils.getBaseName(path).replace(File.pathSeparator, "");
    }
}

