/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.api.RTApi;
import java.util.ArrayList;

public class MonitoredActivity
extends AppCompatActivity {
    protected Handler mHandler;
    private final ArrayList<LifeCycleListener> mListeners = new ArrayList();

    public void addLifeCycleListener(LifeCycleListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeLifeCycleListener(LifeCycleListener listener) {
        this.mListeners.remove(listener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(RTApi.useDarkTheme() ? R.style.RTE_BaseThemeDark : R.style.RTE_BaseThemeLight);
        if (!this.isFinishing()) {
            this.mHandler = new Handler();
            for (LifeCycleListener listener : this.mListeners) {
                listener.onActivityCreated((Activity)this);
            }
        }
    }

    protected void onStart() {
        super.onStart();
        for (LifeCycleListener listener : this.mListeners) {
            listener.onActivityStarted((Activity)this);
        }
    }

    protected void onPause() {
        super.onPause();
        for (LifeCycleListener listener : this.mListeners) {
            listener.onActivityPaused((Activity)this);
        }
    }

    protected void onResume() {
        super.onResume();
        for (LifeCycleListener listener : this.mListeners) {
            listener.onActivityResumed((Activity)this);
        }
    }

    protected void onStop() {
        super.onStop();
        for (LifeCycleListener listener : this.mListeners) {
            listener.onActivityStopped((Activity)this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        for (LifeCycleListener listener : this.mListeners) {
            listener.onActivityDestroyed((Activity)this);
        }
    }

    public <T> T startForegroundJob(int msgId, ForegroundJob<T> job) {
        ProgressDialog dialog = ProgressDialog.show((Context)this, null, (CharSequence)this.getString(msgId), (boolean)true, (boolean)false);
        Job<T> managedJob = new Job<T>(job, dialog);
        return managedJob.runForegroundJob();
    }

    public void startBackgroundJob(int msgId, Runnable runnable) {
        ProgressDialog dialog = ProgressDialog.show((Context)this, null, (CharSequence)this.getString(msgId), (boolean)true, (boolean)false);
        Job managedJob = new Job(runnable, dialog);
        managedJob.runBackgroundJob();
    }

    private class Job<T>
    extends LifeCycleAdapter
    implements ForegroundJob<T> {
        private final ProgressDialog mDialog;
        private final Runnable mRunnable;
        private final ForegroundJob<T> mJob;
        private final Runnable mCleanupRunner = new Runnable(){

            @Override
            public void run() {
                MonitoredActivity.this.removeLifeCycleListener(Job.this);
                if (Job.this.mDialog.getWindow() != null) {
                    Job.this.mDialog.dismiss();
                }
            }
        };

        public Job(ForegroundJob<T> job, ProgressDialog dialog) {
            this.mDialog = dialog;
            this.mJob = job;
            this.mRunnable = null;
            MonitoredActivity.this.addLifeCycleListener(this);
        }

        public Job(Runnable runnable, ProgressDialog dialog) {
            this.mDialog = dialog;
            this.mJob = null;
            this.mRunnable = runnable;
            MonitoredActivity.this.addLifeCycleListener(this);
        }

        @Override
        public T runForegroundJob() {
            try {
                T t = this.mJob.runForegroundJob();
                return t;
            }
            finally {
                MonitoredActivity.this.mHandler.post(this.mCleanupRunner);
            }
        }

        public void runBackgroundJob() {
            try {
                this.mRunnable.run();
            }
            finally {
                MonitoredActivity.this.mHandler.post(this.mCleanupRunner);
            }
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            this.mCleanupRunner.run();
            MonitoredActivity.this.mHandler.removeCallbacks(this.mCleanupRunner);
        }

        @Override
        public void onActivityStopped(Activity activity) {
            this.mDialog.hide();
        }

        @Override
        public void onActivityStarted(Activity activity) {
            this.mDialog.show();
        }
    }

    public static interface ForegroundJob<T> {
        public T runForegroundJob();
    }

    public static class LifeCycleAdapter
    implements LifeCycleListener {
        @Override
        public void onActivityCreated(Activity activity) {
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onActivityResumed(Activity activity) {
        }

        @Override
        public void onActivityStarted(Activity activity) {
        }

        @Override
        public void onActivityStopped(Activity activity) {
        }
    }

    public static interface LifeCycleListener {
        public void onActivityCreated(Activity var1);

        public void onActivityDestroyed(Activity var1);

        public void onActivityPaused(Activity var1);

        public void onActivityResumed(Activity var1);

        public void onActivityStarted(Activity var1);

        public void onActivityStopped(Activity var1);
    }
}

