/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.choose;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import android.widget.Toast;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.media.MediaUtils;
import com.onegravity.rteditor.media.MonitoredActivity;
import com.onegravity.rteditor.media.choose.MediaChooserManager;
import com.onegravity.rteditor.media.choose.processor.VideoProcessor;
import com.onegravity.rteditor.utils.Constants;
import java.io.File;

class VideoChooserManager
extends MediaChooserManager
implements VideoProcessor.VideoProcessorListener {
    private static final String CAPTURED_VIDEO_TEMPLATE = "CAPTURED_VIDEO.mp4";
    private VideoChooserListener mListener;

    VideoChooserManager(MonitoredActivity activity, Constants.MediaAction mediaAction, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory, VideoChooserListener listener, Bundle savedInstanceState) {
        super(activity, mediaAction, mediaFactory, listener, savedInstanceState);
        this.mListener = listener;
    }

    @Override
    boolean chooseMedia() throws IllegalArgumentException {
        if (this.mListener == null) {
            throw new IllegalArgumentException("VideoChooserListener cannot be null");
        }
        switch (this.mMediaAction) {
            case CAPTURE_VIDEO: {
                return this.captureVideo();
            }
            case PICK_VIDEO: {
                return this.pickVideo();
            }
        }
        return false;
    }

    private boolean pickVideo() {
        Intent intent = new Intent("android.intent.action.PICK").setData(MediaStore.Images.Media.EXTERNAL_CONTENT_URI).setType("video/*");
        String title = this.mActivity.getString(R.string.rte_pick_video);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)title));
        return true;
    }

    private boolean captureVideo() {
        try {
            File videoPath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            File videoFile = MediaUtils.createUniqueFile(videoPath, CAPTURED_VIDEO_TEMPLATE, false);
            videoPath.mkdirs();
            if (!videoPath.exists() || !videoPath.createNewFile()) {
                Toast.makeText((Context)this.mActivity, (CharSequence)"Can't take picture without an sdcard", (int)0).show();
                return false;
            }
            this.setOriginalFile(videoFile.getAbsolutePath());
            Intent intent = new Intent("android.media.action.VIDEO_CAPTURE").putExtra("output", (Parcelable)Uri.fromFile((File)new File(this.getOriginalFile())));
            this.startActivity(intent);
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    void processMedia(Constants.MediaAction mediaAction, Intent data) {
        switch (mediaAction) {
            case PICK_VIDEO: {
                this.processPickedVideo(data);
                break;
            }
            case CAPTURE_VIDEO: {
                this.processCameraVideo(data);
            }
        }
    }

    private void processPickedVideo(Intent data) {
        String originalFile = this.determineOriginalFile(data);
        if (originalFile != null) {
            this.startBackgroundJob(new VideoProcessor(originalFile, (RTMediaFactory<RTImage, RTAudio, RTVideo>)this.mMediaFactory, this));
        }
    }

    private void processCameraVideo(Intent intent) {
        String originalFile = this.getOriginalFile();
        if (originalFile != null) {
            this.startBackgroundJob(new VideoProcessor(originalFile, (RTMediaFactory<RTImage, RTAudio, RTVideo>)this.mMediaFactory, this));
        }
    }

    @Override
    public void onVideoProcessed(RTVideo video) {
        if (this.mListener != null) {
            this.mListener.onVideoChosen(video);
        }
    }

    public static interface VideoChooserListener
    extends MediaChooserManager.MediaChooserListener {
        public void onVideoChosen(RTVideo var1);
    }
}

