/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.choose.processor;

import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTMediaSource;
import com.onegravity.rteditor.api.media.RTMediaType;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.media.choose.processor.MediaProcessor;
import java.io.IOException;
import java.io.InputStream;

public class ImageProcessor
extends MediaProcessor {
    private ImageProcessorListener mListener;

    public ImageProcessor(String originalFile, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory, ImageProcessorListener listener) {
        super(originalFile, mediaFactory, listener);
        this.mListener = listener;
    }

    @Override
    protected void processMedia() throws IOException, Exception {
        InputStream in = super.getInputStream();
        if (in == null) {
            if (this.mListener != null) {
                this.mListener.onError("No file found to process");
            }
        } else {
            RTMediaSource source = new RTMediaSource(RTMediaType.IMAGE, in, this.getOriginalFile(), this.getMimeType());
            Object image = this.mMediaFactory.createImage(source);
            if (image != null && this.mListener != null) {
                this.mListener.onImageProcessed((RTImage)image);
            }
        }
    }

    public static interface ImageProcessorListener
    extends MediaProcessor.MediaProcessorListener {
        public void onImageProcessed(RTImage var1);
    }
}

