/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.crop;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.FileDescriptor;
import java.util.Iterator;
import java.util.WeakHashMap;

public class BitmapManager {
    private final WeakHashMap<Thread, ThreadStatus> mThreadStatus = new WeakHashMap();
    private static BitmapManager sManager = null;

    private BitmapManager() {
    }

    private synchronized ThreadStatus getOrCreateThreadStatus(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        if (status == null) {
            status = new ThreadStatus();
            this.mThreadStatus.put(t, status);
        }
        return status;
    }

    private synchronized void setDecodingOptions(Thread t, BitmapFactory.Options options) {
        this.getOrCreateThreadStatus((Thread)t).mOptions = options;
    }

    synchronized BitmapFactory.Options getDecodingOptions(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        return status != null ? status.mOptions : null;
    }

    synchronized void removeDecodingOptions(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        status.mOptions = null;
    }

    public synchronized void allowThreadDecoding(ThreadSet threads) {
        for (Thread t : threads) {
            this.allowThreadDecoding(t);
        }
    }

    public synchronized void cancelThreadDecoding(ThreadSet threads) {
        for (Thread t : threads) {
            this.cancelThreadDecoding(t);
        }
    }

    public synchronized boolean canThreadDecoding(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        if (status == null) {
            return true;
        }
        return status.mState != State.CANCEL;
    }

    public synchronized void allowThreadDecoding(Thread t) {
        this.getOrCreateThreadStatus((Thread)t).mState = State.ALLOW;
    }

    public synchronized void cancelThreadDecoding(Thread t) {
        ThreadStatus status = this.getOrCreateThreadStatus(t);
        status.mState = State.CANCEL;
        if (status.mOptions != null) {
            status.mOptions.requestCancelDecode();
        }
        this.notifyAll();
    }

    public static synchronized BitmapManager instance() {
        if (sManager == null) {
            sManager = new BitmapManager();
        }
        return sManager;
    }

    public Bitmap decodeFileDescriptor(FileDescriptor fd, BitmapFactory.Options options) {
        if (options.mCancel) {
            return null;
        }
        Thread thread = Thread.currentThread();
        if (!this.canThreadDecoding(thread)) {
            return null;
        }
        this.setDecodingOptions(thread, options);
        Bitmap b = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        this.removeDecodingOptions(thread);
        return b;
    }

    public static class ThreadSet
    implements Iterable<Thread> {
        private final WeakHashMap<Thread, Object> mWeakCollection = new WeakHashMap();

        public void add(Thread t) {
            this.mWeakCollection.put(t, null);
        }

        public void remove(Thread t) {
            this.mWeakCollection.remove(t);
        }

        @Override
        public Iterator<Thread> iterator() {
            return this.mWeakCollection.keySet().iterator();
        }
    }

    private static class ThreadStatus {
        public State mState = State.ALLOW;
        public BitmapFactory.Options mOptions;

        private ThreadStatus() {
        }

        public String toString() {
            String s = this.mState == State.CANCEL ? "Cancel" : (this.mState == State.ALLOW ? "Allow" : "?");
            s = "thread state = " + s + ", options = " + this.mOptions;
            return s;
        }
    }

    private static enum State {
        CANCEL,
        ALLOW;

    }
}

