/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor;

import android.annotation.SuppressLint;
import android.text.Spannable;
import com.onegravity.rteditor.RTEditText;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

@SuppressLint(value={"UseSparseArrays"})
class RTOperationManager {
    private static final int MAX_NR_OF_OPERATIONS = 50;
    private static final int TIME_BETWEEN_OPERATIONS = 300;
    private Map<Integer, Stack<Operation>> mUndoStacks = new HashMap<Integer, Stack<Operation>>();
    private Map<Integer, Stack<Operation>> mRedoStacks = new HashMap<Integer, Stack<Operation>>();

    RTOperationManager() {
    }

    synchronized void executed(RTEditText editor, Operation op) {
        Stack<Operation> undoStack = this.getUndoStack(editor);
        Stack<Operation> redoStack = this.getRedoStack(editor);
        while (!undoStack.empty() && op.canMerge(undoStack.peek())) {
            Operation previousOp = undoStack.pop();
            op.merge(previousOp);
        }
        this.push(op, undoStack);
        redoStack.clear();
    }

    synchronized void undo(RTEditText editor) {
        Stack<Operation> undoStack = this.getUndoStack(editor);
        if (!undoStack.empty()) {
            Stack<Operation> redoStack = this.getRedoStack(editor);
            Operation op = undoStack.pop();
            this.push(op, redoStack);
            op.undo(editor);
            while (!undoStack.empty() && op.canMerge(undoStack.peek())) {
                op = undoStack.pop();
                this.push(op, redoStack);
                op.undo(editor);
            }
        }
    }

    synchronized void redo(RTEditText editor) {
        Stack<Operation> redoStack = this.getRedoStack(editor);
        if (!redoStack.empty()) {
            Stack<Operation> undoStack = this.getUndoStack(editor);
            Operation op = redoStack.pop();
            this.push(op, undoStack);
            op.redo(editor);
            while (!redoStack.empty() && op.canMerge(redoStack.peek())) {
                op = redoStack.pop();
                this.push(op, undoStack);
                op.redo(editor);
            }
        }
    }

    synchronized void flushOperations(RTEditText editor) {
        Stack<Operation> undoStack = this.getUndoStack(editor);
        Stack<Operation> redoStack = this.getRedoStack(editor);
        undoStack.clear();
        redoStack.clear();
    }

    private void push(Operation op, Stack<Operation> stack) {
        if (stack.size() >= 50) {
            stack.remove(0);
        }
        stack.push(op);
    }

    private Stack<Operation> getUndoStack(RTEditText editor) {
        return this.getStack(this.mUndoStacks, editor);
    }

    private Stack<Operation> getRedoStack(RTEditText editor) {
        return this.getStack(this.mRedoStacks, editor);
    }

    private Stack<Operation> getStack(Map<Integer, Stack<Operation>> stacks, RTEditText editor) {
        Stack<Operation> stack = stacks.get(editor.getId());
        if (stack == null) {
            stack = new Stack();
            stacks.put(editor.getId(), stack);
        }
        return stack;
    }

    private static abstract class Operation {
        private long mTimestamp;
        private int mSelStartBefore;
        private int mSelEndBefore;
        private Spannable mBefore;
        private int mSelStartAfter;
        private int mSelEndAfter;
        private Spannable mAfter;

        Operation(Spannable before, Spannable after, int selStartBefore, int selEndBefore, int selStartAfter, int selEndAfter) {
            this.mSelStartBefore = selStartBefore;
            this.mSelEndBefore = selEndBefore;
            this.mSelStartAfter = selStartAfter;
            this.mSelEndAfter = selEndAfter;
            this.mBefore = before;
            this.mAfter = after;
            this.mTimestamp = System.currentTimeMillis();
        }

        boolean canMerge(Operation other) {
            return Math.abs(this.mTimestamp - other.mTimestamp) < 300L;
        }

        Operation merge(Operation previousOp) {
            this.mBefore = previousOp.mBefore;
            this.mSelStartBefore = previousOp.mSelStartBefore;
            this.mSelEndBefore = previousOp.mSelEndBefore;
            return this;
        }

        void undo(RTEditText editor) {
            editor.ignoreTextChanges();
            editor.setText((CharSequence)this.mBefore);
            editor.setSelection(this.mSelStartBefore, this.mSelEndBefore);
            editor.registerTextChanges();
        }

        void redo(RTEditText editor) {
            editor.ignoreTextChanges();
            editor.setText((CharSequence)this.mAfter);
            editor.setSelection(this.mSelStartAfter, this.mSelEndAfter);
            editor.registerTextChanges();
        }
    }

    static class TextChangeOperation
    extends Operation {
        TextChangeOperation(Spannable before, Spannable after, int selStartBefore, int selEndBefore, int selStartAfter, int selEndAfter) {
            super(before, after, selStartBefore, selEndBefore, selStartAfter, selEndAfter);
        }
    }
}

