/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.api.format;

import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.view.inputmethod.BaseInputConnection;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.format.RTHtml;
import com.onegravity.rteditor.api.format.RTPlainText;
import com.onegravity.rteditor.api.format.RTSpanned;
import com.onegravity.rteditor.api.format.RTText;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.converter.ConverterSpannedToHtml;
import com.onegravity.rteditor.effects.Effect;
import com.onegravity.rteditor.effects.Effects;

public final class RTEditable
extends RTSpanned {
    private RTEditText mEditor;

    public RTEditable(RTEditText editor) {
        super((Spanned)editor.getText());
        this.mEditor = editor;
    }

    @Override
    public RTText convertTo(RTFormat destFormat, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory) {
        if (destFormat instanceof RTFormat.Html) {
            this.clean();
            return new ConverterSpannedToHtml().convert((Spanned)this.mEditor.getText(), (RTFormat.Html)destFormat);
        }
        if (destFormat instanceof RTFormat.PlainText) {
            this.clean();
            RTHtml<RTImage, RTAudio, RTVideo> rtHtml = new ConverterSpannedToHtml().convert((Spanned)this.mEditor.getText(), RTFormat.HTML);
            RTText rtText = rtHtml.convertTo(RTFormat.PLAIN_TEXT, mediaFactory);
            return new RTPlainText(rtText.getText());
        }
        return super.convertTo(destFormat, mediaFactory);
    }

    private void clean() {
        Editable text = this.mEditor.getText();
        BaseInputConnection.removeComposingSpans((Spannable)text);
        Effects.cleanupParagraphs(this.mEditor, new Effect[0]);
    }
}

