/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.api.format;

import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.format.RTText;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.converter.ConverterHtmlToSpanned;
import com.onegravity.rteditor.converter.ConverterHtmlToText;
import java.util.ArrayList;
import java.util.List;

public class RTHtml<I extends RTImage, A extends RTAudio, V extends RTVideo>
extends RTText {
    private List<I> mImages;

    public RTHtml(CharSequence html) {
        this(RTFormat.HTML, html);
    }

    public RTHtml(RTFormat.Html rtFormat, CharSequence html) {
        this(rtFormat, html, new ArrayList());
    }

    public RTHtml(RTFormat.Html rtFormat, CharSequence html, List<I> images) {
        super(rtFormat, html);
        this.mImages = images;
    }

    @Override
    public String getText() {
        CharSequence text = super.getText();
        return text != null ? text.toString() : "";
    }

    public List<I> getImages() {
        return this.mImages;
    }

    @Override
    public RTText convertTo(RTFormat destFormat, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory) {
        if (destFormat instanceof RTFormat.PlainText) {
            return ConverterHtmlToText.convert(this);
        }
        if (destFormat instanceof RTFormat.Spanned) {
            return new ConverterHtmlToSpanned().convert(this, mediaFactory);
        }
        return super.convertTo(destFormat, mediaFactory);
    }
}

