/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter;

import android.text.Annotation;
import android.text.Editable;
import android.text.Html;
import com.onegravity.rteditor.api.format.RTHtml;
import com.onegravity.rteditor.api.format.RTPlainText;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.xml.sax.XMLReader;

public class ConverterHtmlToText {
    private static final char PREVIEW_OBJECT_CHARACTER = '\ufffc';
    private static final char PREVIEW_OBJECT_REPLACEMENT = ' ';
    private static final char NBSP_CHARACTER = '\u00a0';
    private static final char NBSP_REPLACEMENT = ' ';

    public static RTPlainText convert(RTHtml<? extends RTImage, ? extends RTAudio, ? extends RTVideo> input) {
        String result = Html.fromHtml((String)input.getText(), null, (Html.TagHandler)new HtmlToTextTagHandler()).toString().replace('\ufffc', ' ').replace('\u00a0', ' ');
        return new RTPlainText(result);
    }

    public static String convert(String text) {
        return Html.fromHtml((String)text, null, (Html.TagHandler)new HtmlToTextTagHandler()).toString().replace('\ufffc', ' ').replace('\u00a0', ' ');
    }

    private static class HtmlToTextTagHandler
    implements Html.TagHandler {
        private static final Set<String> TAGS_WITH_IGNORED_CONTENT;
        private static final String IGNORED_ANNOTATION_KEY = "RT_ANNOTATION";
        private static final String IGNORED_ANNOTATION_VALUE = "hiddenSpan";

        private HtmlToTextTagHandler() {
        }

        public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
            if ((tag = tag.toLowerCase(Locale.US)).equals("hr") && opening) {
                output.append((CharSequence)"_____________________________________________\n");
            } else if (TAGS_WITH_IGNORED_CONTENT.contains(tag)) {
                this.handleIgnoredTag(opening, output);
            }
        }

        private void handleIgnoredTag(boolean opening, Editable output) {
            int len = output.length();
            if (opening) {
                output.setSpan((Object)new Annotation(IGNORED_ANNOTATION_KEY, IGNORED_ANNOTATION_VALUE), len, len, 17);
            } else {
                Object start = this.getOpeningAnnotation(output);
                if (start != null) {
                    int where = output.getSpanStart(start);
                    output.removeSpan(start);
                    output.delete(where, len);
                }
            }
        }

        private Object getOpeningAnnotation(Editable output) {
            Object[] objs = output.getSpans(0, output.length(), Annotation.class);
            for (int i = objs.length - 1; i >= 0; --i) {
                Annotation span = (Annotation)objs[i];
                if (output.getSpanFlags(objs[i]) != 17 || !span.getKey().equals(IGNORED_ANNOTATION_KEY) || !span.getValue().equals(IGNORED_ANNOTATION_VALUE)) continue;
                return objs[i];
            }
            return null;
        }

        static {
            HashSet<String> set = new HashSet<String>();
            set.add("style");
            set.add("script");
            set.add("title");
            set.add("!");
            TAGS_WITH_IGNORED_CONTENT = Collections.unmodifiableSet(set);
        }
    }
}

