/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Spannable;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.effects.SpanCollector;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.List;

class CharacterSpanCollector<V>
extends SpanCollector<V> {
    CharacterSpanCollector(Class<? extends RTSpan<V>> spanClazz) {
        super(spanClazz);
    }

    @Override
    protected final List<RTSpan<V>> getSpans(Spannable str, Selection selection, SpanCollectMode mode) {
        RTSpan<V>[] spans;
        ArrayList<RTSpan<V>> result = new ArrayList<RTSpan<V>>();
        int selStart = Math.max(0, selection.start() - 1);
        int selEnd = Math.min(str.length(), selection.end() + 1);
        for (RTSpan span : spans = this.getSpansAndroid(str, selStart, selEnd)) {
            if (!this.isAttached(str, selection, span, mode)) continue;
            result.add(span);
        }
        return result;
    }

    private boolean isAttached(Spannable str, Selection selection, Object span, SpanCollectMode mode) {
        int end;
        int spanStart = str.getSpanStart(span);
        int spanEnd = str.getSpanEnd(span);
        int selStart = selection.start();
        int selEnd = selection.end();
        int start = Math.max(spanStart, selStart);
        if (start > (end = Math.min(spanEnd, selEnd))) {
            return false;
        }
        if (start < end) {
            return true;
        }
        if (spanStart > selStart && spanEnd < selEnd || selStart > spanStart && selEnd < spanEnd) {
            return true;
        }
        if (mode == SpanCollectMode.EXACT) {
            return false;
        }
        int flags = str.getSpanFlags(span) & 0x33;
        if (spanEnd == selStart) {
            return this.isOneFlagSet(flags, 34, 18);
        }
        return this.isOneFlagSet(flags, 17, 18);
    }
}

