/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Editable;
import android.text.Spannable;
import android.util.SparseIntArray;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.Effects;
import com.onegravity.rteditor.effects.ParagraphEffect;
import com.onegravity.rteditor.effects.ParagraphSpanProcessor;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.spans.NumberSpan;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.List;

public class NumberEffect
extends ParagraphEffect<Boolean, NumberSpan> {
    private ParagraphSpanProcessor<Boolean> mSpans2Process = new ParagraphSpanProcessor();

    @Override
    public synchronized void applyToSelection(RTEditText editor, Selection selectedParagraphs, Boolean enable) {
        Editable str = editor.getText();
        this.mSpans2Process.clear();
        int lineNr = 1;
        SparseIntArray indentations = new SparseIntArray();
        SparseIntArray numbers = new SparseIntArray();
        ArrayList<Paragraph> paragraphs = editor.getParagraphs();
        int size = paragraphs.size();
        for (int i = 0; i < size; ++i) {
            boolean hasNumber;
            Paragraph paragraph = paragraphs.get(i);
            int currentIndentation = 0;
            List indentationSpans = Effects.INDENTATION.getSpans((Spannable)str, paragraph, SpanCollectMode.EXACT);
            if (!indentationSpans.isEmpty()) {
                for (RTSpan span : indentationSpans) {
                    currentIndentation += ((Integer)span.getValue()).intValue();
                }
            }
            indentations.put(lineNr, currentIndentation);
            List existingSpans = this.getSpans((Spannable)str, paragraph, SpanCollectMode.SPAN_FLAGS);
            this.mSpans2Process.removeSpans(existingSpans, paragraph);
            boolean hasExistingSpans = !existingSpans.isEmpty();
            boolean bl = hasNumber = paragraph.isSelected(selectedParagraphs) ? enable : hasExistingSpans;
            if (hasNumber) {
                int nr = 1;
                for (int line = 1; line < lineNr; ++line) {
                    int indentation = indentations.get(line);
                    int number = numbers.get(line);
                    if (indentation < currentIndentation) {
                        nr = 1;
                        continue;
                    }
                    if (indentation != currentIndentation) continue;
                    nr = number == 0 ? 1 : number + 1;
                }
                numbers.put(lineNr, nr);
                int margin = Helper.getLeadingMarging();
                NumberSpan numberSpan = new NumberSpan(nr++, margin, paragraph.isEmpty(), paragraph.isFirst(), paragraph.isLast());
                this.mSpans2Process.addSpan(numberSpan, paragraph);
                Effects.BULLET.findSpans2Remove((Spannable)str, paragraph, this.mSpans2Process);
            }
            ++lineNr;
        }
        this.mSpans2Process.process((Spannable)str);
    }
}

