/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Spannable;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.Effect;
import com.onegravity.rteditor.effects.Effects;
import com.onegravity.rteditor.effects.ParagraphSpanCollector;
import com.onegravity.rteditor.effects.ParagraphSpanProcessor;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.effects.SpanCollector;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.Selection;
import java.util.List;

abstract class ParagraphEffect<V, C extends RTSpan<V>>
extends Effect<V, C> {
    ParagraphEffect() {
    }

    @Override
    protected final SpanCollector<V> newSpanCollector(Class<? extends RTSpan<V>> spanClazz) {
        return new ParagraphSpanCollector(spanClazz);
    }

    @Override
    protected final Selection getSelection(RTEditText editor) {
        return editor.getParagraphsInSelection();
    }

    @Override
    public final void applyToSelection(RTEditText editor, V value) {
        Selection selection = this.getSelection(editor);
        this.applyToSelection(editor, selection, value);
        Effects.cleanupParagraphs(editor, this);
    }

    public abstract void applyToSelection(RTEditText var1, Selection var2, V var3);

    protected void findSpans2Remove(Spannable str, Paragraph paragraph, ParagraphSpanProcessor<V> spanProcessor) {
        List spans = this.getSpans(str, paragraph, SpanCollectMode.EXACT);
        spanProcessor.removeSpans(spans, paragraph);
    }
}

