/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.crop;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.media.FaceDetector;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.media.MonitoredActivity;
import com.onegravity.rteditor.media.crop.BitmapManager;
import com.onegravity.rteditor.media.crop.CropImageView;
import com.onegravity.rteditor.media.crop.HighlightView;
import com.onegravity.rteditor.media.crop.RotateBitmap;
import com.onegravity.rteditor.utils.Helper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CropImageActivity
extends MonitoredActivity {
    private final float IMAGE_MAX_SIZE = 1024.0f;
    public static final String IMAGE_SOURCE_FILE = "image-source-file";
    public static final String IMAGE_DESTINATION_FILE = "image-dest-file";
    public static final String SCALE = "scale";
    public static final String ORIENTATION_IN_DEGREES = "orientation_in_degrees";
    public static final String ASPECT_X = "aspectX";
    public static final String ASPECT_Y = "aspectY";
    public static final String OUTPUT_X = "outputX";
    public static final String OUTPUT_Y = "outputY";
    public static final String SCALE_UP_IF_NEEDED = "scaleUpIfNeeded";
    public static final String CIRCLE_CROP = "circleCrop";
    public static final String RETURN_DATA = "return-data";
    public static final String RETURN_DATA_AS_BITMAP = "data";
    public static final String ACTION_INLINE_DATA = "inline-data";
    private Bitmap.CompressFormat mOutputFormat = Bitmap.CompressFormat.JPEG;
    private Uri mSaveUri = null;
    private boolean mDoFaceDetection = false;
    private boolean mCircleCrop = false;
    private int mAspectX;
    private int mAspectY;
    private int mOutputX;
    private int mOutputY;
    private boolean mScale;
    private CropImageView mImageView;
    private Bitmap mBitmap;
    private String mImageSource;
    private String mImageDest;
    boolean mWaitingToPick;
    boolean mSaving;
    HighlightView mCrop;
    private boolean mScaleUp = true;
    private final BitmapManager.ThreadSet mDecodingThreads = new BitmapManager.ThreadSet();
    Runnable mRunFaceDetection = new Runnable(){
        float mScale = 1.0f;
        Matrix mImageMatrix;
        FaceDetector.Face[] mFaces = new FaceDetector.Face[3];
        int mNumFaces;

        private void handleFace(FaceDetector.Face f) {
            PointF midPoint = new PointF();
            int r = (int)(f.eyesDistance() * this.mScale) * 2;
            f.getMidPoint(midPoint);
            midPoint.x *= this.mScale;
            midPoint.y *= this.mScale;
            int midX = (int)midPoint.x;
            int midY = (int)midPoint.y;
            HighlightView hv = new HighlightView((View)CropImageActivity.this.mImageView);
            int width = CropImageActivity.this.mBitmap.getWidth();
            int height = CropImageActivity.this.mBitmap.getHeight();
            Rect imageRect = new Rect(0, 0, width, height);
            RectF faceRect = new RectF((float)midX, (float)midY, (float)midX, (float)midY);
            faceRect.inset((float)(-r), (float)(-r));
            if (faceRect.left < 0.0f) {
                faceRect.inset(-faceRect.left, -faceRect.left);
            }
            if (faceRect.top < 0.0f) {
                faceRect.inset(-faceRect.top, -faceRect.top);
            }
            if (faceRect.right > (float)imageRect.right) {
                faceRect.inset(faceRect.right - (float)imageRect.right, faceRect.right - (float)imageRect.right);
            }
            if (faceRect.bottom > (float)imageRect.bottom) {
                faceRect.inset(faceRect.bottom - (float)imageRect.bottom, faceRect.bottom - (float)imageRect.bottom);
            }
            hv.setup(this.mImageMatrix, imageRect, faceRect, CropImageActivity.this.mCircleCrop, CropImageActivity.this.mAspectX != 0 && CropImageActivity.this.mAspectY != 0);
            CropImageActivity.this.mImageView.add(hv);
        }

        private void makeDefault() {
            HighlightView hv = new HighlightView((View)CropImageActivity.this.mImageView);
            int width = CropImageActivity.this.mBitmap.getWidth();
            int height = CropImageActivity.this.mBitmap.getHeight();
            Rect imageRect = new Rect(0, 0, width, height);
            int cropWidth = width;
            int cropHeight = height;
            if (CropImageActivity.this.mAspectX != 0 && CropImageActivity.this.mAspectY != 0) {
                if (CropImageActivity.this.mAspectX > CropImageActivity.this.mAspectY) {
                    cropHeight = cropWidth * CropImageActivity.this.mAspectY / CropImageActivity.this.mAspectX;
                } else {
                    cropWidth = cropHeight * CropImageActivity.this.mAspectX / CropImageActivity.this.mAspectY;
                }
            }
            int x = (width - cropWidth) / 2;
            int y = (height - cropHeight) / 2;
            RectF cropRect = new RectF((float)x, (float)y, (float)(x + cropWidth), (float)(y + cropHeight));
            hv.setup(this.mImageMatrix, imageRect, cropRect, CropImageActivity.this.mCircleCrop, CropImageActivity.this.mAspectX != 0 && CropImageActivity.this.mAspectY != 0);
            CropImageActivity.this.mImageView.mHighlightViews.clear();
            CropImageActivity.this.mImageView.add(hv);
        }

        private Bitmap prepareBitmap() {
            if (CropImageActivity.this.mBitmap == null) {
                return null;
            }
            if (CropImageActivity.this.mBitmap.getWidth() > 256) {
                this.mScale = 256.0f / (float)CropImageActivity.this.mBitmap.getWidth();
            }
            Matrix matrix = new Matrix();
            matrix.setScale(this.mScale, this.mScale);
            return Bitmap.createBitmap((Bitmap)CropImageActivity.this.mBitmap, (int)0, (int)0, (int)CropImageActivity.this.mBitmap.getWidth(), (int)CropImageActivity.this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }

        @Override
        public void run() {
            this.mImageMatrix = CropImageActivity.this.mImageView.getImageMatrix();
            Bitmap faceBitmap = this.prepareBitmap();
            this.mScale = 1.0f / this.mScale;
            if (faceBitmap != null && CropImageActivity.this.mDoFaceDetection) {
                FaceDetector detector = new FaceDetector(faceBitmap.getWidth(), faceBitmap.getHeight(), this.mFaces.length);
                this.mNumFaces = detector.findFaces(faceBitmap, this.mFaces);
            }
            if (faceBitmap != null && faceBitmap != CropImageActivity.this.mBitmap) {
                faceBitmap.recycle();
            }
            CropImageActivity.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    boolean bl = CropImageActivity.this.mWaitingToPick = mNumFaces > 1;
                    if (mNumFaces > 0) {
                        for (int i = 0; i < mNumFaces; ++i) {
                            this.handleFace(mFaces[i]);
                        }
                    } else {
                        this.makeDefault();
                    }
                    CropImageActivity.this.mImageView.invalidate();
                    if (CropImageActivity.this.mImageView.mHighlightViews.size() == 1) {
                        CropImageActivity.this.mCrop = CropImageActivity.this.mImageView.mHighlightViews.get(0);
                        CropImageActivity.this.mCrop.setFocus(true);
                    }
                }
            });
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rte_crop_image);
        this.mImageView = (CropImageView)this.findViewById(R.id.image);
        Intent intent = this.getIntent();
        Bundle extras = intent.getExtras();
        if (extras != null) {
            if (extras.getString(CIRCLE_CROP) != null) {
                this.mImageView.setLayerType(1, null);
                this.mCircleCrop = true;
                this.mAspectX = 1;
                this.mAspectY = 1;
            }
            this.mImageSource = extras.getString(IMAGE_SOURCE_FILE);
            this.mBitmap = this.getBitmap(this.mImageSource);
            this.mImageDest = extras.getString(IMAGE_DESTINATION_FILE);
            if (this.mImageDest == null) {
                this.mImageDest = this.mImageSource;
            }
            this.mSaveUri = Uri.fromFile((File)new File(this.mImageDest));
            if (!extras.containsKey(ASPECT_X) || !(extras.get(ASPECT_X) instanceof Integer)) {
                throw new IllegalArgumentException("aspect_x must be integer");
            }
            this.mAspectX = extras.getInt(ASPECT_X);
            if (!extras.containsKey(ASPECT_Y) || !(extras.get(ASPECT_Y) instanceof Integer)) {
                throw new IllegalArgumentException("aspect_y must be integer");
            }
            this.mAspectY = extras.getInt(ASPECT_Y);
            this.mOutputX = extras.getInt(OUTPUT_X);
            this.mOutputY = extras.getInt(OUTPUT_Y);
            this.mScale = extras.getBoolean(SCALE, true);
            this.mScaleUp = extras.getBoolean(SCALE_UP_IF_NEEDED, true);
        }
        if (this.mBitmap == null) {
            this.finish();
            return;
        }
        this.startFaceDetection();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        this.getMenuInflater().inflate(R.menu.rte_crop_image, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.save) {
            try {
                this.onSave();
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
                this.finish();
            }
            return true;
        }
        if (itemId == R.id.cancel) {
            this.setResult(0);
            this.finish();
            return true;
        }
        if (itemId == R.id.rotate_left) {
            this.mBitmap = this.rotateImage(this.mBitmap, -90.0f);
            RotateBitmap rotateBitmap = new RotateBitmap(this.mBitmap);
            this.mImageView.setImageRotateBitmapResetBase(rotateBitmap, true);
            this.mRunFaceDetection.run();
            return true;
        }
        if (itemId == R.id.rotate_right) {
            this.mBitmap = this.rotateImage(this.mBitmap, 90.0f);
            RotateBitmap rotateBitmap = new RotateBitmap(this.mBitmap);
            this.mImageView.setImageRotateBitmapResetBase(rotateBitmap, true);
            this.mRunFaceDetection.run();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    /*
     * Exception decompiling
     */
    private Bitmap getBitmap(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Bitmap getBitmap(InputStream in, Uri uri, float scale) throws Throwable {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        options.inSampleSize = Math.round(scale);
        in = this.getContentResolver().openInputStream(uri);
        return BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)options);
    }

    private void startFaceDetection() {
        if (this.isFinishing()) {
            return;
        }
        this.mImageView.setImageBitmapResetBase(this.mBitmap, true);
        this.startBackgroundJob(R.string.rte_processing_image, new Runnable(){

            @Override
            public void run() {
                Bitmap b = CropImageActivity.this.mBitmap;
                if (b != CropImageActivity.this.mBitmap && b != null) {
                    CropImageActivity.this.mImageView.setImageBitmapResetBase(b, true);
                    CropImageActivity.this.mBitmap.recycle();
                    CropImageActivity.this.mBitmap = b;
                }
                if (CropImageActivity.this.mImageView.getScale() == 1.0f) {
                    CropImageActivity.this.mImageView.center(true, true);
                }
                CropImageActivity.this.mRunFaceDetection.run();
            }
        });
    }

    private void onSave() throws Exception {
        Bundle myExtras;
        if (this.mSaving) {
            return;
        }
        if (this.mCrop == null) {
            return;
        }
        this.mSaving = true;
        Rect r = this.mCrop.getCropRect();
        int width = r.width();
        int height = r.height();
        Bitmap croppedImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(this.mCircleCrop ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        if (croppedImage == null) {
            return;
        }
        Canvas canvas = new Canvas(croppedImage);
        Rect dstRect = new Rect(0, 0, width, height);
        canvas.drawBitmap(this.mBitmap, r, dstRect, null);
        if (this.mCircleCrop) {
            Canvas c = new Canvas(croppedImage);
            Path p = new Path();
            p.addCircle((float)width / 2.0f, (float)height / 2.0f, (float)width / 2.0f, Path.Direction.CW);
            c.clipPath(p, Region.Op.DIFFERENCE);
            c.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        if (this.mOutputX != 0 && this.mOutputY != 0) {
            if (this.mScale) {
                Bitmap old = croppedImage;
                if (old != (croppedImage = this.transform(new Matrix(), croppedImage, this.mOutputX, this.mOutputY, this.mScaleUp))) {
                    old.recycle();
                }
            } else {
                Bitmap b = Bitmap.createBitmap((int)this.mOutputX, (int)this.mOutputY, (Bitmap.Config)Bitmap.Config.RGB_565);
                Canvas canvas2 = new Canvas(b);
                Rect srcRect = this.mCrop.getCropRect();
                Rect dstRect2 = new Rect(0, 0, this.mOutputX, this.mOutputY);
                int dx = (srcRect.width() - dstRect2.width()) / 2;
                int dy = (srcRect.height() - dstRect2.height()) / 2;
                srcRect.inset(Math.max(0, dx), Math.max(0, dy));
                dstRect2.inset(Math.max(0, -dx), Math.max(0, -dy));
                canvas2.drawBitmap(this.mBitmap, srcRect, dstRect2, null);
                croppedImage.recycle();
                croppedImage = b;
            }
        }
        if ((myExtras = this.getIntent().getExtras()) != null && (myExtras.getParcelable(RETURN_DATA_AS_BITMAP) != null || myExtras.getBoolean(RETURN_DATA))) {
            Bundle extras = new Bundle();
            extras.putParcelable(RETURN_DATA_AS_BITMAP, (Parcelable)croppedImage);
            this.setResult(-1, new Intent().setAction(ACTION_INLINE_DATA).putExtras(extras));
            this.finish();
        } else {
            final Bitmap b = croppedImage;
            this.startBackgroundJob(R.string.rte_processing_image, new Runnable(){

                @Override
                public void run() {
                    CropImageActivity.this.saveOutput(b);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutput(Bitmap croppedImage) {
        if (this.mSaveUri != null) {
            OutputStream out = null;
            try {
                out = this.getContentResolver().openOutputStream(this.mSaveUri);
                if (out != null) {
                    croppedImage.compress(this.mOutputFormat, 90, out);
                }
            }
            catch (IOException ex) {
                try {
                    Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Cannot open file: " + this.mSaveUri), (Throwable)ex);
                    this.setResult(0);
                    this.finish();
                }
                catch (Throwable throwable) {
                    Helper.closeQuietly(out);
                    throw throwable;
                }
                Helper.closeQuietly(out);
                return;
            }
            Helper.closeQuietly(out);
            Bundle extras = new Bundle();
            Intent intent = new Intent(this.mSaveUri.toString());
            intent.putExtras(extras);
            intent.putExtra(IMAGE_SOURCE_FILE, this.mImageSource);
            intent.putExtra(IMAGE_DESTINATION_FILE, this.mImageDest);
            intent.putExtra(ORIENTATION_IN_DEGREES, this.getOrientationInDegree((Activity)this));
            this.setResult(-1, intent);
        } else {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"not defined image url");
        }
        croppedImage.recycle();
        this.finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        BitmapManager.instance().cancelThreadDecoding(this.mDecodingThreads);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
    }

    private Bitmap transform(Matrix scaler, Bitmap source, int targetWidth, int targetHeight, boolean scaleUp) {
        float viewAspect;
        float bitmapHeightF;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b2 = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b2);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            return b2;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        if (bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight)) {
            scale = (float)targetHeight / bitmapHeightF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        } else {
            scale = (float)targetWidth / bitmapWidthF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)scaler, (boolean)true) : source;
        int dx1 = Math.max(0, b1.getWidth() - targetWidth);
        int dy1 = Math.max(0, b1.getHeight() - targetHeight);
        Bitmap b2 = Bitmap.createBitmap((Bitmap)b1, (int)(dx1 / 2), (int)(dy1 / 2), (int)targetWidth, (int)targetHeight);
        if (b1 != source) {
            b1.recycle();
        }
        return b2;
    }

    private Bitmap rotateImage(Bitmap src, float degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate(degree);
        Bitmap bmp = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
        return bmp;
    }

    private int getOrientationInDegree(Activity activity) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        return degrees;
    }
}

