/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import com.onegravity.rteditor.spans.BaseListItemSpan;
import com.onegravity.rteditor.spans.RTParagraphSpan;
import com.onegravity.rteditor.spans.RTSpan;

public class NumberSpan
extends BaseListItemSpan
implements LeadingMarginSpan,
RTSpan<Boolean>,
RTParagraphSpan<Boolean> {
    private final int mNr;
    private final int mGapWidth;
    private final boolean mIgnoreSpan;
    private float mWidth;

    public NumberSpan(int nr, int gapWidth, boolean isEmpty, boolean isFirst, boolean isLast) {
        this.mNr = nr;
        this.mGapWidth = gapWidth;
        this.mIgnoreSpan = isEmpty && isLast && !isFirst;
    }

    private NumberSpan(int nr, int gapWidth, boolean ignoreSpan) {
        this.mNr = nr;
        this.mGapWidth = gapWidth;
        this.mIgnoreSpan = ignoreSpan;
    }

    public int getLeadingMargin(boolean first) {
        return this.mIgnoreSpan ? 0 : Math.max(Math.round(this.mWidth + 2.0f), this.mGapWidth);
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
        Spanned spanned = (Spanned)text;
        if (!this.mIgnoreSpan && spanned.getSpanStart((Object)this) == start) {
            Paint.Style oldStyle = p.getStyle();
            float oldTextSize = p.getTextSize();
            p.setStyle(Paint.Style.FILL);
            float textSize = this.determineTextSize(spanned, start, end, oldTextSize);
            p.setTextSize(textSize);
            this.mWidth = p.measureText(this.mNr + ".");
            c.drawText(this.mNr + ".", (float)x, (float)baseline, p);
            p.setStyle(oldStyle);
            p.setTextSize(oldTextSize);
        }
    }

    @Override
    public Boolean getValue() {
        return Boolean.TRUE;
    }

    public NumberSpan createClone() {
        return new NumberSpan(this.mNr, this.mGapWidth, this.mIgnoreSpan);
    }
}

