/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.utils;

import android.text.Spanned;
import com.onegravity.rteditor.utils.Paragraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RTLayout
implements Serializable {
    private static final long serialVersionUID = 2210969820444215580L;
    private static final Pattern LINEBREAK_PATTERN = Pattern.compile("\\r\\n|\\r|\\n");
    private int mNrOfLines = 0;
    private final ArrayList<Paragraph> mParagraphs = new ArrayList();

    public RTLayout(Spanned spanned) {
        if (spanned != null) {
            Paragraph paragraph;
            String s = spanned.toString();
            this.mNrOfLines = 1;
            Matcher m = LINEBREAK_PATTERN.matcher(s);
            int groupStart = 0;
            while (m.find()) {
                paragraph = new Paragraph(groupStart, m.end(), this.mNrOfLines == 1, false);
                this.mParagraphs.add(paragraph);
                groupStart = m.end();
                ++this.mNrOfLines;
            }
            if (this.mParagraphs.size() < this.mNrOfLines) {
                paragraph = new Paragraph(groupStart, s.length(), this.mNrOfLines == 1, true);
                this.mParagraphs.add(paragraph);
            }
        }
    }

    public ArrayList<Paragraph> getParagraphs() {
        return this.mParagraphs;
    }

    public int getLineForOffset(int offset) {
        int lineNr;
        for (lineNr = 0; lineNr < this.mNrOfLines && offset >= this.mParagraphs.get(lineNr).end(); ++lineNr) {
        }
        return Math.min(Math.max(0, lineNr), this.mParagraphs.size() - 1);
    }

    public int getLineStart(int line) {
        return this.mNrOfLines == 0 || line < 0 ? 0 : (line < this.mNrOfLines ? this.mParagraphs.get(line).start() : this.mParagraphs.get(this.mNrOfLines - 1).end() - 1);
    }

    public int getLineEnd(int line) {
        return this.mNrOfLines == 0 || line < 0 ? 0 : (line < this.mNrOfLines ? this.mParagraphs.get(line).end() : this.mParagraphs.get(this.mNrOfLines - 1).end() - 1);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        int line = 1;
        for (Paragraph p : this.mParagraphs) {
            s.append(line++).append(": ").append(p.start()).append("-").append(p.end()).append(p.isLast() ? "" : ", ");
        }
        return s.toString();
    }
}

