/*
 * Decompiled with CFR 0.152.
 */
package com.a21buttons.cropimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.ImageView;
import com.a21buttons.cropimageview.CropImageView;
import com.a21buttons.cropimageview.CropImageViewKt;
import com.a21buttons.cropimageview.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Q2\u00020\u0001:\u0003QRSB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020(0*H\u0002J(\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u00020(H\u0002J%\u00101\u001a\u00020(2\u001a\b\u0004\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001102H\u0082\bJ\u0006\u00103\u001a\u00020(J\u0006\u00104\u001a\u00020(J\u0010\u00105\u001a\u00020(2\u0006\u00106\u001a\u00020\fH\u0002J\n\u00107\u001a\u0004\u0018\u000108H\u0002J\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010;0:J\u0010\u0010<\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020?H\u0014J(\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tH\u0014J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u000e\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020\u0011J\u0012\u0010K\u001a\u00020(2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020PH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0012\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R$\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006T"}, d2={"Lcom/a21buttons/cropimageview/CropImageView;", "Landroid/support/v7/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_matrix", "Landroid/graphics/Matrix;", "_values", "", "value", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "aspectRatio", "getAspectRatio", "()Lkotlin/ranges/ClosedFloatingPointRange;", "setAspectRatio", "(Lkotlin/ranges/ClosedFloatingPointRange;)V", "drawableHeight", "Ljava/lang/Integer;", "drawableWidth", "gestureDetector", "Landroid/view/GestureDetector;", "scaleGestureDetector", "Landroid/view/ScaleGestureDetector;", "viewportHeight", "viewportOverlayColor", "getViewportOverlayColor", "()I", "setViewportOverlayColor", "(I)V", "viewportPaint", "Landroid/graphics/Paint;", "viewportWidth", "applyMatrixTransformation", "", "action", "Lkotlin/Function1;", "calculateTranslation", "translation", "dScaledSize", "vSize", "viewportSize", "calculateViewportSize", "center", "Lkotlin/Function2;", "centerCrop", "centerInside", "checkLimits", "matrix", "croppedRect", "Landroid/graphics/Rect;", "getCoppedBitmap", "Lkotlin/Function0;", "Landroid/graphics/Bitmap;", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "rotate", "degrees", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setScaleType", "scaleType", "Landroid/widget/ImageView$ScaleType;", "Companion", "MyOnGestureListener", "MyOnScaleGestureListener", "cropimageview_release"})
public final class CropImageView
extends AppCompatImageView {
    private final ScaleGestureDetector scaleGestureDetector;
    private final GestureDetector gestureDetector;
    private Integer drawableWidth;
    private Integer drawableHeight;
    private Integer viewportWidth;
    private Integer viewportHeight;
    private final Paint viewportPaint;
    @NotNull
    private ClosedFloatingPointRange<Float> aspectRatio;
    private final Matrix _matrix;
    private final float[] _values;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
        try {
            this.viewportPaint.setColor(typedArray.getColor(R.styleable.CropImageView_viewportOverlayColor, (int)0x80000000L));
        }
        finally {
            typedArray.recycle();
        }
    }

    @NotNull
    public final ClosedFloatingPointRange<Float> getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(@NotNull ClosedFloatingPointRange<Float> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        if (value.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("The range can't be empty");
        }
        if (Intrinsics.areEqual(this.aspectRatio, value) ^ true) {
            this.aspectRatio = value;
            this.calculateViewportSize();
            this.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this){
                final /* synthetic */ CropImageView this$0;

                public final void invoke(@NotNull Matrix it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    CropImageView.access$checkLimits(this.this$0, it);
                }
                {
                    this.this$0 = cropImageView;
                    super(1);
                }
            }));
            this.invalidate();
        }
    }

    public final int getViewportOverlayColor() {
        return this.viewportPaint.getColor();
    }

    public final void setViewportOverlayColor(int value) {
        if (this.viewportPaint.getColor() != value) {
            this.viewportPaint.setColor(value);
            this.invalidate();
        }
    }

    public void setScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        super.setImageDrawable(drawable);
        Drawable drawable2 = drawable;
        this.drawableWidth = drawable2 != null ? Integer.valueOf(drawable2.getIntrinsicWidth()) : null;
        Drawable drawable3 = drawable;
        this.drawableHeight = drawable3 != null ? Integer.valueOf(drawable3.getIntrinsicHeight()) : null;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        boolean scaleGestureResult = this.scaleGestureDetector.onTouchEvent(event);
        boolean gestureResult = this.gestureDetector.onTouchEvent(event);
        boolean superResult = super.onTouchEvent(event);
        return scaleGestureResult || gestureResult || superResult;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Integer n = this.viewportWidth;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int viewportWidth = n;
        Integer n2 = this.viewportHeight;
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        int viewportHeight = n2;
        float width = this.getWidth();
        float height = this.getHeight();
        float top = (height - (float)viewportHeight) / 2.0f;
        float bottom = height - top;
        float left = (width - (float)viewportWidth) / 2.0f;
        float right = width - left;
        canvas.drawRect(0.0f, top, left, bottom, this.viewportPaint);
        canvas.drawRect(0.0f, 0.0f, width, top, this.viewportPaint);
        canvas.drawRect(right, top, width, bottom, this.viewportPaint);
        canvas.drawRect(0.0f, bottom, width, height, this.viewportPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.calculateViewportSize();
        this.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this){
            final /* synthetic */ CropImageView this$0;

            public final void invoke(@NotNull Matrix it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CropImageView.access$checkLimits(this.this$0, it);
            }
            {
                this.this$0 = cropImageView;
                super(1);
            }
        }));
    }

    public final void centerCrop() {
        CropImageView this_$iv = this;
        Integer n = this_$iv.drawableWidth;
        Float dWidth$iv = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = this_$iv.drawableHeight;
        Float dHeight$iv = n2 != null ? Float.valueOf(n2.intValue()) : null;
        Integer n3 = this_$iv.viewportWidth;
        Float viewportWidth$iv = n3 != null ? Float.valueOf(n3.intValue()) : null;
        Integer n4 = this_$iv.viewportHeight;
        Float viewportHeight$iv = n4 != null ? Float.valueOf(n4.intValue()) : null;
        int vWidth$iv = this_$iv.getWidth() - this_$iv.getPaddingLeft() - this_$iv.getPaddingRight();
        int vHeight$iv = this_$iv.getHeight() - this_$iv.getPaddingTop() - this_$iv.getPaddingBottom();
        if (dWidth$iv != null && dHeight$iv != null && viewportWidth$iv != null && viewportHeight$iv != null) {
            this_$iv.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this_$iv, viewportWidth$iv, dWidth$iv, viewportHeight$iv, dHeight$iv, vWidth$iv, vHeight$iv){
                final /* synthetic */ CropImageView this$0;
                final /* synthetic */ Float $viewportWidth;
                final /* synthetic */ Float $dWidth;
                final /* synthetic */ Float $viewportHeight;
                final /* synthetic */ Float $dHeight;
                final /* synthetic */ int $vWidth;
                final /* synthetic */ int $vHeight;
                {
                    this.this$0 = cropImageView;
                    this.$viewportWidth = f;
                    this.$dWidth = f2;
                    this.$viewportHeight = f3;
                    this.$dHeight = f4;
                    this.$vWidth = n;
                    this.$vHeight = n2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Matrix it) {
                    void b;
                    void a;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    float rotation = CropImageViewKt.access$getRotation(it);
                    float f = this.$viewportHeight.floatValue() / this.$dHeight.floatValue();
                    float f2 = this.$viewportWidth.floatValue() / this.$dWidth.floatValue();
                    Companion companion = CropImageView.Companion;
                    float f3 = Math.max((float)a, (float)b);
                    float scale = com.a21buttons.cropimageview.CropImageView$Companion.access$checkMinScale(companion, f3, this.this$0.getAspectRatio(), rotation, this.$dWidth.floatValue(), this.$dHeight.floatValue(), this.$viewportWidth.floatValue(), this.$viewportHeight.floatValue());
                    float tx = ((float)this.$vWidth - this.$dWidth.floatValue() * scale) / 2.0f;
                    float ty = ((float)this.$vHeight - this.$dHeight.floatValue() * scale) / 2.0f;
                    it.setScale(scale, scale);
                    it.postTranslate(tx, ty);
                    it.postRotate(CropImageViewKt.access$toDegrees(rotation), (float)this.$vWidth / 2.0f, (float)this.$vHeight / 2.0f);
                }
            }));
        }
    }

    public final void centerInside() {
        CropImageView this_$iv = this;
        Integer n = this_$iv.drawableWidth;
        Float dWidth$iv = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = this_$iv.drawableHeight;
        Float dHeight$iv = n2 != null ? Float.valueOf(n2.intValue()) : null;
        Integer n3 = this_$iv.viewportWidth;
        Float viewportWidth$iv = n3 != null ? Float.valueOf(n3.intValue()) : null;
        Integer n4 = this_$iv.viewportHeight;
        Float viewportHeight$iv = n4 != null ? Float.valueOf(n4.intValue()) : null;
        int vWidth$iv = this_$iv.getWidth() - this_$iv.getPaddingLeft() - this_$iv.getPaddingRight();
        int vHeight$iv = this_$iv.getHeight() - this_$iv.getPaddingTop() - this_$iv.getPaddingBottom();
        if (dWidth$iv != null && dHeight$iv != null && viewportWidth$iv != null && viewportHeight$iv != null) {
            this_$iv.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this_$iv, viewportWidth$iv, dWidth$iv, viewportHeight$iv, dHeight$iv, vWidth$iv, vHeight$iv){
                final /* synthetic */ CropImageView this$0;
                final /* synthetic */ Float $viewportWidth;
                final /* synthetic */ Float $dWidth;
                final /* synthetic */ Float $viewportHeight;
                final /* synthetic */ Float $dHeight;
                final /* synthetic */ int $vWidth;
                final /* synthetic */ int $vHeight;
                {
                    this.this$0 = cropImageView;
                    this.$viewportWidth = f;
                    this.$dWidth = f2;
                    this.$viewportHeight = f3;
                    this.$dHeight = f4;
                    this.$vWidth = n;
                    this.$vHeight = n2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Matrix it) {
                    void b;
                    void a;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    float rotation = CropImageViewKt.access$getRotation(it);
                    float f = this.$viewportHeight.floatValue() / this.$dHeight.floatValue();
                    float f2 = this.$viewportWidth.floatValue() / this.$dWidth.floatValue();
                    Companion companion = CropImageView.Companion;
                    float f3 = Math.min((float)a, (float)b);
                    float scale = com.a21buttons.cropimageview.CropImageView$Companion.access$checkMinScale(companion, f3, this.this$0.getAspectRatio(), rotation, this.$dWidth.floatValue(), this.$dHeight.floatValue(), this.$viewportWidth.floatValue(), this.$viewportHeight.floatValue());
                    float tx = ((float)this.$vWidth - this.$dWidth.floatValue() * scale) / 2.0f;
                    float ty = ((float)this.$vHeight - this.$dHeight.floatValue() * scale) / 2.0f;
                    it.setScale(scale, scale);
                    it.postTranslate(tx, ty);
                    it.postRotate(CropImageViewKt.access$toDegrees(rotation), (float)this.$vWidth / 2.0f, (float)this.$vHeight / 2.0f);
                }
            }));
        }
    }

    private final void center(Function2<? super Float, ? super Float, Float> action) {
        Integer n = this.drawableWidth;
        Float dWidth = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = this.drawableHeight;
        Float dHeight = n2 != null ? Float.valueOf(n2.intValue()) : null;
        Integer n3 = this.viewportWidth;
        Float viewportWidth = n3 != null ? Float.valueOf(n3.intValue()) : null;
        Integer n4 = this.viewportHeight;
        Float viewportHeight = n4 != null ? Float.valueOf(n4.intValue()) : null;
        int vWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int vHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        if (dWidth == null || dHeight == null || viewportWidth == null || viewportHeight == null) {
            return;
        }
        this.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this, action, viewportWidth, dWidth, viewportHeight, dHeight, vWidth, vHeight){
            final /* synthetic */ CropImageView this$0;
            final /* synthetic */ Function2 $action;
            final /* synthetic */ Float $viewportWidth;
            final /* synthetic */ Float $dWidth;
            final /* synthetic */ Float $viewportHeight;
            final /* synthetic */ Float $dHeight;
            final /* synthetic */ int $vWidth;
            final /* synthetic */ int $vHeight;

            public final void invoke(@NotNull Matrix it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                float rotation = CropImageViewKt.access$getRotation(it);
                float scale = com.a21buttons.cropimageview.CropImageView$Companion.access$checkMinScale(CropImageView.Companion, ((Number)this.$action.invoke((Object)Float.valueOf(this.$viewportWidth.floatValue() / this.$dWidth.floatValue()), (Object)Float.valueOf(this.$viewportHeight.floatValue() / this.$dHeight.floatValue()))).floatValue(), this.this$0.getAspectRatio(), rotation, this.$dWidth.floatValue(), this.$dHeight.floatValue(), this.$viewportWidth.floatValue(), this.$viewportHeight.floatValue());
                float tx = ((float)this.$vWidth - this.$dWidth.floatValue() * scale) / 2.0f;
                float ty = ((float)this.$vHeight - this.$dHeight.floatValue() * scale) / 2.0f;
                it.setScale(scale, scale);
                it.postTranslate(tx, ty);
                it.postRotate(CropImageViewKt.access$toDegrees(rotation), (float)this.$vWidth / 2.0f, (float)this.$vHeight / 2.0f);
            }
            {
                this.this$0 = cropImageView;
                this.$action = function2;
                this.$viewportWidth = f;
                this.$dWidth = f2;
                this.$viewportHeight = f3;
                this.$dHeight = f4;
                this.$vWidth = n;
                this.$vHeight = n2;
                super(1);
            }
        }));
    }

    public final void rotate(float degrees) {
        int vWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int vHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this, degrees, vWidth, vHeight){
            final /* synthetic */ CropImageView this$0;
            final /* synthetic */ float $degrees;
            final /* synthetic */ int $vWidth;
            final /* synthetic */ int $vHeight;

            public final void invoke(@NotNull Matrix it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.postRotate(this.$degrees, (float)this.$vWidth / 2.0f, (float)this.$vHeight / 2.0f);
                CropImageView.access$checkLimits(this.this$0, it);
            }
            {
                this.this$0 = cropImageView;
                this.$degrees = f;
                this.$vWidth = n;
                this.$vHeight = n2;
                super(1);
            }
        }));
    }

    private final void applyMatrixTransformation(Function1<? super Matrix, Unit> action) {
        Float viewportHeight;
        Integer n = this.drawableWidth;
        Float dWidth = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = this.drawableHeight;
        Float dHeight = n2 != null ? Float.valueOf(n2.intValue()) : null;
        Integer n3 = this.viewportWidth;
        Float viewportWidth = n3 != null ? Float.valueOf(n3.intValue()) : null;
        Integer n4 = this.viewportHeight;
        Float f = viewportHeight = n4 != null ? Float.valueOf(n4.intValue()) : null;
        if (dWidth == null || dHeight == null || viewportWidth == null || viewportHeight == null) {
            return;
        }
        this._matrix.set(this.getImageMatrix());
        action.invoke((Object)this._matrix);
        this.setImageMatrix(this._matrix);
    }

    private final void checkLimits(Matrix matrix) {
        Integer n = this.drawableWidth;
        Float dWidth = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = this.drawableHeight;
        Float dHeight = n2 != null ? Float.valueOf(n2.intValue()) : null;
        Integer n3 = this.viewportWidth;
        Float viewportWidth = n3 != null ? Float.valueOf(n3.intValue()) : null;
        Integer n4 = this.viewportHeight;
        Float viewportHeight = n4 != null ? Float.valueOf(n4.intValue()) : null;
        float vWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        float vHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        if (dWidth == null || dHeight == null || viewportWidth == null || viewportHeight == null) {
            return;
        }
        matrix.getValues(this._values);
        float f = this._values[0] * this._values[0] + this._values[3] * this._values[3];
        float scale = (float)Math.sqrt(f);
        float f2 = this._values[0] / scale;
        float acosTheta = (float)Math.acos(f2);
        float f3 = this._values[3] / scale;
        float theta = (float)Math.asin(f3) >= -0.0f ? acosTheta : (float)Math.PI * 2 - acosTheta;
        float degrees = CropImageViewKt.access$toDegrees(theta);
        float px = vWidth / 2.0f;
        float py = vHeight / 2.0f;
        matrix.postRotate(-degrees, px, py);
        matrix.getValues(this._values);
        scale = CropImageView.Companion.checkMinScale(scale, (ClosedFloatingPointRange<Float>)this.aspectRatio, theta, dWidth.floatValue(), dHeight.floatValue(), viewportWidth.floatValue(), viewportHeight.floatValue());
        float dScaledWidth = dWidth.floatValue() * scale;
        float dScaledHeight = dHeight.floatValue() * scale;
        float tx = this.calculateTranslation(this._values[2], dScaledWidth, vWidth, viewportWidth.floatValue());
        float ty = this.calculateTranslation(this._values[5], dScaledHeight, vHeight, viewportHeight.floatValue());
        matrix.setScale(scale, scale);
        matrix.postTranslate(tx, ty);
        matrix.postRotate(degrees, px, py);
    }

    private final void calculateViewportSize() {
        int viewportHeight;
        int viewportWidth;
        int vHeight;
        int vWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        float vAspectRatio = (float)vWidth / (float)(vHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        if (!this.aspectRatio.contains((Comparable)Float.valueOf(vAspectRatio))) {
            float viewportAspectRatio;
            float f = ((Number)((Object)this.aspectRatio.getEndInclusive())).floatValue() < 1.0f ? ((Number)((Object)this.aspectRatio.getEndInclusive())).floatValue() : (viewportAspectRatio = ((Number)((Object)this.aspectRatio.getStart())).floatValue() > 1.0f ? ((Number)((Object)this.aspectRatio.getStart())).floatValue() : 1.0f);
            if (viewportAspectRatio > vAspectRatio) {
                viewportWidth = vWidth;
                viewportHeight = MathKt.roundToInt((float)((float)viewportWidth * viewportAspectRatio));
            } else {
                viewportHeight = vHeight;
                viewportWidth = MathKt.roundToInt((float)((float)viewportHeight / viewportAspectRatio));
            }
        } else {
            viewportWidth = vWidth;
            viewportHeight = vHeight;
        }
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
    }

    private final float calculateTranslation(float translation, float dScaledSize, float vSize, float viewportSize) {
        float f;
        if (dScaledSize < viewportSize) {
            f = (vSize - dScaledSize) / 2.0f;
        } else {
            float a = (vSize - viewportSize) / 2.0f;
            float f2 = Math.min(a, translation);
            float f3 = vSize - dScaledSize - a;
            f = Math.max(f2, f3);
        }
        return f;
    }

    @NotNull
    public final Function0<Bitmap> getCoppedBitmap() {
        Function0 function0;
        Rect rect = this.croppedRect();
        if (rect == null) {
            function0 = getCoppedBitmap.1.INSTANCE;
        } else {
            Drawable d = this.getDrawable();
            function0 = (Function0)new Function0<Bitmap>(d, rect){
                final /* synthetic */ Drawable $d;
                final /* synthetic */ Rect $rect;

                @Nullable
                public final Bitmap invoke() {
                    Drawable drawable = this.$d;
                    if (!(drawable instanceof BitmapDrawable)) {
                        throw (Throwable)new RuntimeException("Not supported drawable");
                    }
                    Bitmap bitmap = ((BitmapDrawable)this.$d).getBitmap();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"d.bitmap");
                    return CropImageViewKt.access$crop(bitmap, this.$rect);
                }
                {
                    this.$d = drawable;
                    this.$rect = rect;
                    super(0);
                }
            };
        }
        return function0;
    }

    private final Rect croppedRect() {
        Float viewportHeight;
        Integer n = this.drawableWidth;
        Float dWidth = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = this.drawableHeight;
        Float dHeight = n2 != null ? Float.valueOf(n2.intValue()) : null;
        Integer n3 = this.viewportWidth;
        Float viewportWidth = n3 != null ? Float.valueOf(n3.intValue()) : null;
        Integer n4 = this.viewportHeight;
        Float f = viewportHeight = n4 != null ? Float.valueOf(n4.intValue()) : null;
        if (dWidth == null || dHeight == null || viewportWidth == null || viewportHeight == null) {
            return null;
        }
        this.getImageMatrix().getValues(this._values);
        float f2 = this._values[0] * this._values[0] + this._values[3] * this._values[3];
        float scale = (float)Math.sqrt(f2);
        float f3 = 0.0f;
        float f4 = (this._values[2] - ((float)this.getWidth() - viewportWidth.floatValue()) / (float)2) / scale;
        float left = -Math.min(f3, f4);
        f4 = 0.0f;
        float f5 = (this._values[5] - ((float)this.getHeight() - viewportHeight.floatValue()) / (float)2) / scale;
        float top = -Math.min(f4, f5);
        f5 = dWidth.floatValue();
        float f6 = viewportWidth.floatValue() / scale;
        float f7 = left;
        float f8 = Math.min(f5, f6);
        float right = f7 + f8;
        f6 = dHeight.floatValue();
        float f9 = viewportHeight.floatValue() / scale;
        f7 = top;
        f8 = Math.min(f6, f9);
        float bottom = f7 + f8;
        f9 = 0.0f;
        int x = MathKt.roundToInt((float)Math.max(f9, left));
        float f10 = 0.0f;
        int y = MathKt.roundToInt((float)Math.max(f10, top));
        float f11 = dWidth.floatValue();
        int x2 = MathKt.roundToInt((float)Math.min(f11, right));
        float f12 = dHeight.floatValue();
        int y2 = MathKt.roundToInt((float)Math.min(f12, bottom));
        return new Rect(x, y, x2, y2);
    }

    public CropImageView(@NotNull Context context) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new MyOnScaleGestureListener());
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new MyOnGestureListener());
        super.setScaleType(ImageView.ScaleType.MATRIX);
        Paint paint2 = new Paint();
        CropImageView cropImageView = this;
        Paint $receiver = paint2;
        $receiver.setColor((int)0x80000000L);
        cropImageView.viewportPaint = paint = paint2;
        this.aspectRatio = RangesKt.rangeTo((float)0.8f, (float)1.0f);
        this._matrix = new Matrix();
        this._values = new float[9];
    }

    public CropImageView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new MyOnScaleGestureListener());
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new MyOnGestureListener());
        super.setScaleType(ImageView.ScaleType.MATRIX);
        Paint paint2 = new Paint();
        CropImageView cropImageView = this;
        Paint $receiver = paint2;
        $receiver.setColor((int)0x80000000L);
        cropImageView.viewportPaint = paint = paint2;
        this.aspectRatio = RangesKt.rangeTo((float)0.8f, (float)1.0f);
        this._matrix = new Matrix();
        this._values = new float[9];
        this.init(attrs);
    }

    public CropImageView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new MyOnScaleGestureListener());
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new MyOnGestureListener());
        super.setScaleType(ImageView.ScaleType.MATRIX);
        Paint paint2 = new Paint();
        CropImageView cropImageView = this;
        Paint $receiver = paint2;
        $receiver.setColor((int)0x80000000L);
        cropImageView.viewportPaint = paint = paint2;
        this.aspectRatio = RangesKt.rangeTo((float)0.8f, (float)1.0f);
        this._matrix = new Matrix();
        this._values = new float[9];
        this.init(attrs);
    }

    public static final /* synthetic */ void access$checkLimits(CropImageView $this, @NotNull Matrix matrix) {
        $this.checkLimits(matrix);
    }

    public static final /* synthetic */ void access$setDrawableWidth$p(CropImageView $this, @Nullable Integer n) {
        $this.drawableWidth = n;
    }

    public static final /* synthetic */ void access$setDrawableHeight$p(CropImageView $this, @Nullable Integer n) {
        $this.drawableHeight = n;
    }

    public static final /* synthetic */ void access$setViewportWidth$p(CropImageView $this, @Nullable Integer n) {
        $this.viewportWidth = n;
    }

    public static final /* synthetic */ void access$setViewportHeight$p(CropImageView $this, @Nullable Integer n) {
        $this.viewportHeight = n;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/a21buttons/cropimageview/CropImageView$MyOnScaleGestureListener;", "Landroid/view/ScaleGestureDetector$OnScaleGestureListener;", "(Lcom/a21buttons/cropimageview/CropImageView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "onScaleBegin", "onScaleEnd", "", "cropimageview_release"})
    private final class MyOnScaleGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            return true;
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            CropImageView.this.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this, detector){
                final /* synthetic */ MyOnScaleGestureListener this$0;
                final /* synthetic */ ScaleGestureDetector $detector;

                public final void invoke(@NotNull Matrix it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    float scaleFactor = this.$detector.getScaleFactor();
                    it.postScale(scaleFactor, scaleFactor, this.$detector.getFocusX(), this.$detector.getFocusY());
                    CropImageView.access$checkLimits(this.this$0.CropImageView.this, it);
                }
                {
                    this.this$0 = myOnScaleGestureListener;
                    this.$detector = scaleGestureDetector;
                    super(1);
                }
            }));
            return true;
        }

        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/a21buttons/cropimageview/CropImageView$MyOnGestureListener;", "Landroid/view/GestureDetector$OnGestureListener;", "(Lcom/a21buttons/cropimageview/CropImageView;)V", "onDown", "", "e", "Landroid/view/MotionEvent;", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onLongPress", "", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "cropimageview_release"})
    private final class MyOnGestureListener
    implements GestureDetector.OnGestureListener {
        public boolean onDown(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return false;
        }

        public void onShowPress(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        }

        public boolean onSingleTapUp(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return false;
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        }

        public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            return false;
        }

        public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            CropImageView.this.applyMatrixTransformation((Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(this, distanceX, distanceY){
                final /* synthetic */ MyOnGestureListener this$0;
                final /* synthetic */ float $distanceX;
                final /* synthetic */ float $distanceY;

                public final void invoke(@NotNull Matrix it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    it.postTranslate(-this.$distanceX, -this.$distanceY);
                    CropImageView.access$checkLimits(this.this$0.CropImageView.this, it);
                }
                {
                    this.this$0 = myOnGestureListener;
                    this.$distanceX = f;
                    this.$distanceY = f2;
                    super(1);
                }
            }));
            return true;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/a21buttons/cropimageview/CropImageView$Companion;", "", "()V", "checkMinScale", "", "scale", "aspectRatio", "Lkotlin/ranges/ClosedFloatingPointRange;", "rotation", "drawableWidth", "drawableHeight", "viewportWidth", "viewportHeight", "isNearTo90or270", "", "angle", "cropimageview_release"})
    public static final class Companion {
        private final float checkMinScale(float scale, ClosedFloatingPointRange<Float> aspectRatio2, float rotation, float drawableWidth, float drawableHeight, float viewportWidth, float viewportHeight) {
            float dHeight;
            float dWidth;
            if (this.isNearTo90or270(rotation)) {
                dWidth = drawableHeight;
                dHeight = drawableWidth;
            } else {
                dWidth = drawableWidth;
                dHeight = drawableHeight;
            }
            float f = ((Number)((Object)aspectRatio2.getStart())).floatValue() * viewportHeight / dWidth;
            float f2 = viewportWidth / (((Number)((Object)aspectRatio2.getEndInclusive())).floatValue() * dHeight);
            f = Math.max(f, f2);
            f = Math.max(scale, f);
            f2 = viewportWidth / dWidth;
            float f3 = viewportHeight / dHeight;
            f2 = Math.min(f2, f3);
            return Math.max(f, f2);
        }

        private final boolean isNearTo90or270(float angle) {
            double angle45 = 0.7853981633974483;
            return (double)angle > angle45 && (double)angle < (double)3 * angle45 || (double)angle > (double)5 * angle45 && (double)angle < (double)7 * angle45;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

