/*
 * Decompiled with CFR 0.152.
 */
package com.android21buttons.fragmenttestrule;

import android.util.Log;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.test.rule.ActivityTestRule;

public class FragmentTestRule<A extends FragmentActivity, F extends Fragment>
extends ActivityTestRule<A> {
    private static final String TAG = "FragmentTestRule";
    private final Class<F> fragmentClass;
    private final boolean launchFragment;
    private F fragment;

    public static <F extends Fragment> FragmentTestRule<?, F> create(Class<F> fragmentClass) {
        return new FragmentTestRule<FragmentActivity, F>(FragmentActivity.class, fragmentClass);
    }

    public static <F extends Fragment> FragmentTestRule<?, F> create(Class<F> fragmentClass, boolean initialTouchMode) {
        return new FragmentTestRule<FragmentActivity, F>(FragmentActivity.class, fragmentClass, initialTouchMode);
    }

    public static <F extends Fragment> FragmentTestRule<?, F> create(Class<F> fragmentClass, boolean initialTouchMode, boolean launchFragment) {
        return new FragmentTestRule<FragmentActivity, F>(FragmentActivity.class, fragmentClass, initialTouchMode, true, launchFragment);
    }

    public FragmentTestRule(Class<A> activityClass, Class<F> fragmentClass) {
        this(activityClass, fragmentClass, false);
    }

    public FragmentTestRule(Class<A> activityClass, Class<F> fragmentClass, boolean initialTouchMode) {
        this(activityClass, fragmentClass, initialTouchMode, true);
    }

    public FragmentTestRule(Class<A> activityClass, Class<F> fragmentClass, boolean initialTouchMode, boolean launchActivity) {
        this(activityClass, fragmentClass, initialTouchMode, launchActivity, true);
    }

    public FragmentTestRule(Class<A> activityClass, Class<F> fragmentClass, boolean initialTouchMode, boolean launchActivity, boolean launchFragment) {
        super(activityClass, initialTouchMode, launchActivity);
        this.fragmentClass = fragmentClass;
        this.launchFragment = launchFragment;
    }

    protected void afterActivityLaunched() {
        if (this.launchFragment) {
            this.launchFragment(this.createFragment());
        }
    }

    public void launchFragment(F fragment) {
        try {
            this.runOnUiThread(new Runnable((Fragment)fragment){
                final /* synthetic */ Fragment val$fragment;
                {
                    this.val$fragment = fragment;
                }

                @Override
                public void run() {
                    Object fragment2 = this.val$fragment == null ? FragmentTestRule.this.createFragment() : this.val$fragment;
                    FragmentTestRule.this.fragment = fragment2;
                    ((FragmentActivity)FragmentTestRule.this.getActivity()).getSupportFragmentManager().beginTransaction().replace(0x1020002, fragment2).commitNow();
                }
            });
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected F createFragment() {
        try {
            return (F)((Fragment)this.fragmentClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)String.format("%s: Could not insert %s into %s: %s", ((Object)((Object)this)).getClass().getSimpleName(), this.fragmentClass.getSimpleName(), ((FragmentActivity)this.getActivity()).getClass().getSimpleName(), e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)String.format("%s: Could not insert %s into %s: %s", ((Object)((Object)this)).getClass().getSimpleName(), this.fragmentClass.getSimpleName(), ((FragmentActivity)this.getActivity()).getClass().getSimpleName(), e.getMessage()));
        }
    }

    public F getFragment() {
        if (this.fragment == null) {
            Log.w((String)TAG, (String)"Fragment wasn't created yet");
        }
        return this.fragment;
    }
}

