package com.zoi7.component.zookeeper;

import org.springframework.boot.context.properties.ConfigurationProperties;


/**
 * @author yjy
 * 2019-04-13 12:54
 */
@ConfigurationProperties(ZkConfig.ZK_PREFIX)
public class ZkConfig {

    public static final String ZK_PREFIX = "zookeeper";

    /** 主机 */
    private String host = "127.0.0.1";
    /** 端口 */
    private int port = 2181;
    /** 会话超时时间 */
    private int sessionTimeout = 30000;

    public ZkConfig() {}

    public ZkConfig(String host, int port, int sessionTimeout) {
        this.host = host;
        this.port = port;
        this.sessionTimeout = sessionTimeout;
    }

    public String getPath() {
        return this.host + ":" + this.port;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String toString() {
        return "ZkConfig{" +
                "host='" + host + '\'' +
                ", port=" + port +
                ", sessionTimeout=" + sessionTimeout +
                '}';
    }

    public int getSessionTimeout() {
        return sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }
}
