/*
 * Decompiled with CFR 0.152.
 */
package fetch;

import cats.data.NonEmptyList;
import fetch.Concurrent;
import fetch.DataSource;
import fetch.Env;
import fetch.FetchException;
import fetch.FetchMany;
import fetch.FetchOne;
import fetch.FetchQuery;
import fetch.FetchRequest;
import fetch.MissingIdentities;
import fetch.NotFound;
import fetch.Round;
import fetch.UnhandledException;
import fetch.document.Document;
import fetch.document.Document$;
import java.io.StringWriter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class debug$ {
    public static final debug$ MODULE$;

    static {
        new debug$();
    }

    public String string(Document doc) {
        StringWriter writer = new StringWriter();
        doc.format(1, writer);
        return writer.toString();
    }

    public Document pile(Seq<Document> docs) {
        return (Document)docs.foldLeft((Object)Document$.MODULE$.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Document apply(Document x$1, Document x$2) {
                Document document = x$1;
                return x$2.$colon$div$colon(document);
            }
        });
    }

    public Document showDuration(double secs) {
        double arg$macro$1 = secs;
        return Document$.MODULE$.text(new StringOps(" took %2f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)})));
    }

    public Document showEnv(Env env) {
        Document document;
        scala.collection.immutable.Seq seq = env.rounds();
        if (Nil$.MODULE$.equals(seq)) {
            document = Document$.MODULE$.empty();
        } else {
            Document durationDoc;
            Option result = env.rounds().lastOption().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Round last) {
                    return last.response();
                }
            });
            Document resultDoc = (Document)result.fold((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Document apply() {
                    return Document$.MODULE$.empty();
                }
            }, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Document apply(Object r) {
                    return Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r})));
                }
            });
            Option duration = env.rounds().headOption().flatMap((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final Env env$1;

                public final Option<Object> apply(Round first) {
                    return this.env$1.rounds().lastOption().map((Function1)new Serializable(this, first){
                        public static final long serialVersionUID = 0L;
                        private final Round first$1;

                        public final long apply(Round last) {
                            return last.end() - this.first$1.start();
                        }
                        {
                            this.first$1 = first$1;
                        }
                    });
                }
                {
                    this.env$1 = env$1;
                }
            });
            Document document2 = durationDoc = (Document)duration.fold((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Document apply() {
                    return Document$.MODULE$.empty();
                }
            }, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Document apply(long d) {
                    Document document = Document$.MODULE$.text("Fetch execution");
                    return debug$.MODULE$.showDuration((double)d / 1.0E9).$colon$colon(document);
                }
            });
            document = Document$.MODULE$.nest(2, this.pile((Seq<Document>)((Seq)env.rounds().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Document apply(Round r) {
                    return debug$.MODULE$.showRound(r);
                }
            }, Seq$.MODULE$.canBuildFrom())))).$colon$div$colon(document2);
        }
        return document;
    }

    public Document showRound(Round r) {
        Round round;
        block8: {
            Document document;
            block6: {
                Document document2;
                FetchRequest fetchRequest;
                block7: {
                    FetchRequest q;
                    block5: {
                        FetchRequest q2;
                        round = r;
                        if (round == null || !((q2 = round.request()) instanceof FetchOne)) break block5;
                        FetchOne fetchOne = (FetchOne)q2;
                        Document document3 = this.showQuery((FetchQuery<?, ?>)fetchOne);
                        document = this.showDuration(r.duration() / 1000000.0).$colon$colon(document3);
                        break block6;
                    }
                    if (round == null || !((q = round.request()) instanceof FetchMany)) break block7;
                    FetchMany fetchMany = (FetchMany)q;
                    Document document4 = this.showQuery((FetchQuery<?, ?>)fetchMany);
                    document = this.showDuration(r.duration() / 1000000.0).$colon$colon(document4);
                    break block6;
                }
                if (round == null || !((fetchRequest = round.request()) instanceof Concurrent)) break block8;
                Concurrent concurrent = (Concurrent)fetchRequest;
                NonEmptyList queries = concurrent.queries();
                if (queries.tail().isEmpty()) {
                    Document document5 = this.showQuery((FetchQuery)queries.head());
                    document2 = this.showDuration(r.duration() / 1000000.0).$colon$colon(document5);
                } else {
                    Document document6 = Document$.MODULE$.text("[Concurrent]");
                    Document document7 = this.showDuration(r.duration() / 1000000.0);
                    document2 = Document$.MODULE$.nest(2, this.pile((Seq<Document>)((Seq)queries.toList().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Document apply(FetchQuery<?, ?> q) {
                            return debug$.MODULE$.showQuery(q);
                        }
                    }, List$.MODULE$.canBuildFrom())))).$colon$colon(document7).$colon$colon(document6);
                }
                document = document2;
            }
            return document;
        }
        throw new MatchError((Object)round);
    }

    public Document showQuery(FetchQuery<?, ?> q) {
        FetchQuery<?, ?> fetchQuery;
        block4: {
            Document document;
            block3: {
                block2: {
                    fetchQuery = q;
                    if (!(fetchQuery instanceof FetchOne)) break block2;
                    FetchOne fetchOne = (FetchOne)fetchQuery;
                    Object id = fetchOne.id();
                    DataSource ds = fetchOne.ds();
                    document = Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Fetch one] From `", "` with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ds.name(), id})));
                    break block3;
                }
                if (!(fetchQuery instanceof FetchMany)) break block4;
                FetchMany fetchMany = (FetchMany)fetchQuery;
                NonEmptyList ids = fetchMany.ids();
                DataSource ds = fetchMany.ds();
                document = Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Fetch many] From `", "` with ids ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ds.name(), ids.toList()})));
            }
            return document;
        }
        throw new MatchError(fetchQuery);
    }

    public Document showMissing(String ds, List<?> ids) {
        return Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "` missing identities ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ds, ids})));
    }

    public Document showRoundCount(FetchException err) {
        return Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", fetch interrupted after ", " rounds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)err.env().rounds().size())})));
    }

    public Document showException(FetchException err) {
        FetchException fetchException;
        block5: {
            Document document;
            block3: {
                block4: {
                    block2: {
                        NotFound notFound;
                        FetchOne q;
                        fetchException = err;
                        if (!(fetchException instanceof NotFound) || !((q = (notFound = (NotFound)fetchException).request()) instanceof FetchOne)) break block2;
                        FetchOne fetchOne = q;
                        Object id = fetchOne.id();
                        DataSource ds = fetchOne.ds();
                        Document document2 = Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Error] Identity not found: ", " in `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, ds.name()})));
                        document = this.showRoundCount(err).$colon$colon(document2);
                        break block3;
                    }
                    if (!(fetchException instanceof MissingIdentities)) break block4;
                    MissingIdentities missingIdentities = (MissingIdentities)fetchException;
                    Map missing = missingIdentities.missing();
                    Document document3 = Document$.MODULE$.text("[Error] Missing identities");
                    Document document4 = this.showRoundCount(err);
                    document = Document$.MODULE$.nest(2, this.pile((Seq<Document>)((Seq)missing.toSeq().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Document apply(Tuple2<String, List<Object>> kv) {
                            return debug$.MODULE$.showMissing((String)kv._1(), (List)kv._2());
                        }
                    }, scala.collection.Seq$.MODULE$.canBuildFrom())))).$colon$div$colon(document4).$colon$colon(document3);
                    break block3;
                }
                if (!(fetchException instanceof UnhandledException)) break block5;
                UnhandledException unhandledException = (UnhandledException)fetchException;
                Throwable exc = unhandledException.err();
                Document document5 = Document$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Error] Unhandled `", "`: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exc.getClass().getName(), exc.getMessage()})));
                document = this.showRoundCount(err).$colon$colon(document5);
            }
            return document;
        }
        throw new MatchError((Object)fetchException);
    }

    public String describe(Env env) {
        return this.string(this.showEnv(env));
    }

    public String describe(FetchException err) {
        Document document = this.showException(err);
        return this.string(Document$.MODULE$.nest(2, this.showEnv(err.env())).$colon$div$colon(document));
    }

    private debug$() {
        MODULE$ = this;
    }
}

