/*
 * Decompiled with CFR 0.152.
 */
package fetch;

import cats.data.NonEmptyList;
import cats.instances.package;
import cats.syntax.package;
import fetch.Data;
import fetch.Log;
import fetch.Request;
import fetch.Round;
import fetch.document.Document;
import fetch.document.Document$;
import fetch.package;
import java.io.Serializable;
import java.io.StringWriter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class debug$ {
    public static final debug$ MODULE$ = new debug$();

    public String string(Document doc) {
        StringWriter writer = new StringWriter();
        doc.format(1, writer);
        return writer.toString();
    }

    public Document pile(Seq<Document> docs) {
        return (Document)docs.foldLeft((Object)Document$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Document document = x$1;
            return x$2.$colon$div$colon(document);
        });
    }

    public Document showDuration(long millis) {
        double secs;
        double arg$macro$1 = secs = (double)millis / 1000.0;
        return Document$.MODULE$.text(StringOps$.MODULE$.format$extension(" \ud83d\udd5b %1.2f seconds", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)})));
    }

    public Option<Object> firstRequest(Round r) {
        return r.queries().headOption().map((Function1 & Serializable)aQuery -> BoxesRunTime.boxToLong((long)debug$.$anonfun$firstRequest$1(r, aQuery)));
    }

    public Option<Object> lastRequest(Round r) {
        return r.queries().headOption().map((Function1 & Serializable)aQuery -> BoxesRunTime.boxToLong((long)debug$.$anonfun$lastRequest$1(r, aQuery)));
    }

    public Document showLog(Log log) {
        Document document;
        List list = log.rounds();
        if (Nil$.MODULE$.equals(list)) {
            document = Document$.MODULE$.empty();
        } else {
            Document durationDoc;
            Option duration = log.rounds().headOption().flatMap((Function1 & Serializable)firstRound -> MODULE$.firstRequest((Round)firstRound).flatMap((Function1 & Serializable)firstRequestStart -> debug$.$anonfun$showLog$2(log, BoxesRunTime.unboxToLong((Object)firstRequestStart))));
            Document document2 = durationDoc = (Document)duration.fold((Function0 & Serializable)() -> Document$.MODULE$.empty(), (Function1 & Serializable)d -> debug$.$anonfun$showLog$6(BoxesRunTime.unboxToLong((Object)d)));
            document = Document$.MODULE$.nest(2, this.pile((Seq<Document>)((Seq)package.all$.MODULE$.toTraverseOps((Object)log.rounds(), package.all$.MODULE$.catsStdInstancesForList()).mapWithIndex((Function2 & Serializable)(r, i) -> debug$.MODULE$.showRound(r, BoxesRunTime.unboxToInt((Object)i) + 1))))).$colon$div$colon(document2);
        }
        return document;
    }

    public Document showRound(Round r2, int n) {
        Document round;
        Option roundDuration = this.firstRequest(r2).flatMap((Function1 & Serializable)f -> debug$.$anonfun$showRound$1(r2, BoxesRunTime.unboxToLong((Object)f)));
        Document document = Document$.MODULE$.text(new StringBuilder(8).append("[Round ").append(n).append("]").toString());
        Document document2 = round = ((Document)roundDuration.fold((Function0 & Serializable)() -> Document$.MODULE$.text(""), (Function1 & Serializable)x$5 -> debug$.MODULE$.showDuration(BoxesRunTime.unboxToLong((Object)x$5)))).$colon$colon(document);
        return Document$.MODULE$.nest(2, this.pile((Seq<Document>)r2.queries().map((Function1 & Serializable)r -> MODULE$.showRequest((Request)r)))).$colon$colon(document2);
    }

    public Document showRequest(Request r) {
        Document document;
        package.FetchRequest fetchRequest = r.request();
        if (fetchRequest instanceof package.FetchOne) {
            package.FetchOne fetchOne = (package.FetchOne)fetchRequest;
            Object id = fetchOne.id();
            Data d = fetchOne.data();
            Document document2 = Document$.MODULE$.text(new StringBuilder(28).append("[Fetch one] From `").append(d.name()).append("` with id ").append(id).toString());
            document = this.showDuration(r.duration()).$colon$colon(document2);
        } else if (fetchRequest instanceof package.Batch) {
            package.Batch batch = (package.Batch)fetchRequest;
            NonEmptyList ids = batch.ids();
            Data d = batch.data();
            Document document3 = Document$.MODULE$.text(new StringBuilder(25).append("[Batch] From `").append(d.name()).append("` with ids ").append(ids.toList()).toString());
            document = this.showDuration(r.duration()).$colon$colon(document3);
        } else {
            throw new MatchError((Object)fetchRequest);
        }
        return document;
    }

    public Document showMissing(Data<?, ?> d, List<?> ids) {
        return Document$.MODULE$.text(new StringBuilder(22).append("`").append(d.name()).append("` missing identities ").append(ids).toString());
    }

    public Document showRoundCount(package.FetchException err) {
        return Document$.MODULE$.text(new StringBuilder(33).append(", fetch interrupted after ").append(err.log().rounds().size()).append(" rounds").toString());
    }

    public Document showException(package.FetchException err) {
        Document document;
        package.FetchException fetchException = err;
        if (fetchException instanceof package.MissingIdentity) {
            package.MissingIdentity missingIdentity = (package.MissingIdentity)fetchException;
            Object id = missingIdentity.i();
            package.FetchQuery q = missingIdentity.request();
            Document document2 = Document$.MODULE$.text(new StringBuilder(56).append("[ERROR] Identity with id `").append(id).append("` for data source `").append(q.data().name()).append("` not found").toString());
            document = this.showRoundCount(err).$colon$colon(document2);
        } else if (fetchException instanceof package.UnhandledException) {
            package.UnhandledException unhandledException = (package.UnhandledException)fetchException;
            Throwable exc = unhandledException.e();
            Document document3 = Document$.MODULE$.text(new StringBuilder(24).append("[ERROR] Unhandled `").append(exc.getClass().getName()).append("`: '").append(exc.getMessage()).append("'").toString());
            document = this.showRoundCount(err).$colon$colon(document3);
        } else {
            throw new MatchError((Object)fetchException);
        }
        return document;
    }

    public String describe(Log log) {
        return this.string(this.showLog(log));
    }

    public String describe(Throwable err) {
        String string;
        Throwable throwable = err;
        if (throwable instanceof package.FetchException) {
            package.FetchException fetchException = (package.FetchException)throwable;
            Document document = this.showException(fetchException);
            string = this.string(Document$.MODULE$.nest(2, this.showLog(fetchException.log())).$colon$div$colon(document));
        } else {
            string = this.string(Document$.MODULE$.text("Unexpected exception"));
        }
        return string;
    }

    public static final /* synthetic */ long $anonfun$firstRequest$2(long x0$1, Request x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long acc = tuple2._1$mcJ$sp();
        Request q = (Request)tuple2._2();
        long l = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(acc), q.start());
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$firstRequest$1(Round r$1, Request aQuery) {
        void var2_2;
        long firstR = BoxesRunTime.unboxToLong((Object)r$1.queries().foldLeft((Object)BoxesRunTime.boxToLong((long)aQuery.start()), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)debug$.$anonfun$firstRequest$2(BoxesRunTime.unboxToLong((Object)x0$1), x1$1))));
        return (long)var2_2;
    }

    public static final /* synthetic */ long $anonfun$lastRequest$2(long x0$1, Request x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long acc = tuple2._1$mcJ$sp();
        Request q = (Request)tuple2._2();
        long l = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(acc), q.end());
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$lastRequest$1(Round r$2, Request aQuery) {
        void var2_2;
        long lastR = BoxesRunTime.unboxToLong((Object)r$2.queries().foldLeft((Object)BoxesRunTime.boxToLong((long)aQuery.end()), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)debug$.$anonfun$lastRequest$2(BoxesRunTime.unboxToLong((Object)x0$1), x1$1))));
        return (long)var2_2;
    }

    public static final /* synthetic */ Option $anonfun$showLog$2(Log log$1, long firstRequestStart) {
        return log$1.rounds().lastOption().flatMap((Function1 & Serializable)lastRound -> MODULE$.lastRequest((Round)lastRound).map((Function1)(JFunction1.mcJJ.sp & Serializable)lastRequestEnd -> lastRequestEnd - firstRequestStart));
    }

    public static final /* synthetic */ Document $anonfun$showLog$6(long d) {
        Document document = Document$.MODULE$.text("Fetch execution");
        return MODULE$.showDuration(d).$colon$colon(document);
    }

    public static final /* synthetic */ Option $anonfun$showRound$1(Round r$3, long f) {
        return MODULE$.lastRequest(r$3).map((Function1)(JFunction1.mcJJ.sp & Serializable)l -> l - f);
    }

    private debug$() {
    }
}

